/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.controller.internal.ProvisionAction;
import id.onyx.obdp.server.orm.entities.TopologyHostGroupEntity;
import id.onyx.obdp.server.orm.entities.TopologyLogicalRequestEntity;
import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.Collection;

@Entity
@Table(name="topology_request")
@TableGenerator(name="topology_request_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="topology_request_id_seq", initialValue=0)
@NamedQueries(value={@NamedQuery(name="TopologyRequestEntity.findByClusterId", query="SELECT req FROM TopologyRequestEntity req WHERE req.clusterId = :clusterId"), @NamedQuery(name="TopologyRequestEntity.findProvisionRequests", query="SELECT req FROM TopologyRequestEntity req WHERE req.action = 'PROVISION'")})
public class TopologyRequestEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="topology_request_id_generator")
    @Column(name="id", nullable=false, updatable=false)
    private Long id;
    @Column(name="action", length=255, nullable=false)
    private String action;
    @Column(name="cluster_id", nullable=true)
    private Long clusterId;
    @Column(name="bp_name", length=100, nullable=false)
    private String blueprintName;
    @Column(name="cluster_properties")
    @Basic(fetch=FetchType.LAZY)
    @Lob
    private String clusterProperties;
    @Column(name="cluster_attributes")
    @Basic(fetch=FetchType.LAZY)
    @Lob
    private String clusterAttributes;
    @Column(name="description", length=1024, nullable=false)
    private String description;
    @OneToMany(mappedBy="topologyRequestEntity", cascade={CascadeType.ALL})
    private Collection<TopologyHostGroupEntity> topologyHostGroupEntities;
    @OneToOne(mappedBy="topologyRequestEntity", cascade={CascadeType.ALL})
    private TopologyLogicalRequestEntity topologyLogicalRequestEntity;
    @Column(name="provision_action", length=255, nullable=true)
    @Enumerated(value=EnumType.STRING)
    private ProvisionAction provisionAction;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public String getBlueprintName() {
        return this.blueprintName;
    }

    public void setBlueprintName(String blueprintName) {
        this.blueprintName = blueprintName;
    }

    public String getClusterProperties() {
        return this.clusterProperties;
    }

    public void setClusterProperties(String clusterProperties) {
        this.clusterProperties = clusterProperties;
    }

    public String getClusterAttributes() {
        return this.clusterAttributes;
    }

    public void setClusterAttributes(String clusterAttributes) {
        this.clusterAttributes = clusterAttributes;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Collection<TopologyHostGroupEntity> getTopologyHostGroupEntities() {
        return this.topologyHostGroupEntities;
    }

    public void setTopologyHostGroupEntities(Collection<TopologyHostGroupEntity> topologyHostGroupEntities) {
        this.topologyHostGroupEntities = topologyHostGroupEntities;
    }

    public TopologyLogicalRequestEntity getTopologyLogicalRequestEntity() {
        return this.topologyLogicalRequestEntity;
    }

    public void setTopologyLogicalRequestEntity(TopologyLogicalRequestEntity topologyLogicalRequestEntity) {
        this.topologyLogicalRequestEntity = topologyLogicalRequestEntity;
    }

    public ProvisionAction getProvisionAction() {
        return this.provisionAction;
    }

    public void setProvisionAction(ProvisionAction provisionAction) {
        this.provisionAction = provisionAction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologyRequestEntity that = (TopologyRequestEntity)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

