/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.HostRoleCommandEntity;
import id.onyx.obdp.server.orm.entities.TopologyHostTaskEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;

@Entity
@Table(name="topology_logical_task")
@TableGenerator(name="topology_logical_task_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="topology_logical_task_id_seq", initialValue=0)
@NamedQueries(value={@NamedQuery(name="TopologyLogicalTaskEntity.findHostTaskIdsByPhysicalTaskIds", query="SELECT DISTINCT logicaltask.hostTaskId from TopologyLogicalTaskEntity logicaltask WHERE logicaltask.physicalTaskId IN :physicalTaskIds"), @NamedQuery(name="TopologyLogicalTaskEntity.removeByPhysicalTaskIds", query="DELETE FROM TopologyLogicalTaskEntity logicaltask WHERE logicaltask.physicalTaskId IN :taskIds")})
public class TopologyLogicalTaskEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="topology_logical_task_id_generator")
    @Column(name="id", nullable=false, updatable=false)
    private Long id;
    @Column(name="component", length=255)
    private String componentName;
    @Column(name="host_task_id", nullable=false, insertable=false, updatable=false)
    private Long hostTaskId;
    @Column(name="physical_task_id", nullable=false, insertable=false, updatable=false)
    private Long physicalTaskId;
    @ManyToOne
    @JoinColumn(name="host_task_id", referencedColumnName="id", nullable=false)
    private TopologyHostTaskEntity topologyHostTaskEntity;
    @OneToOne
    @JoinColumn(name="physical_task_id", referencedColumnName="task_id", nullable=false)
    private HostRoleCommandEntity hostRoleCommandEntity;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPhysicalTaskId() {
        return this.hostRoleCommandEntity != null ? this.hostRoleCommandEntity.getTaskId() : null;
    }

    public void setPhysicalTaskId(Long physicalTaskId) {
        this.physicalTaskId = physicalTaskId;
    }

    public void setHostTaskId(Long hostTaskId) {
        this.hostTaskId = hostTaskId;
    }

    public Long getHostTaskId() {
        return this.hostTaskId;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public TopologyHostTaskEntity getTopologyHostTaskEntity() {
        return this.topologyHostTaskEntity;
    }

    public void setTopologyHostTaskEntity(TopologyHostTaskEntity topologyHostTaskEntity) {
        this.topologyHostTaskEntity = topologyHostTaskEntity;
    }

    public HostRoleCommandEntity getHostRoleCommandEntity() {
        return this.hostRoleCommandEntity;
    }

    public void setHostRoleCommandEntity(HostRoleCommandEntity hostRoleCommandEntity) {
        this.hostRoleCommandEntity = hostRoleCommandEntity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologyLogicalTaskEntity that = (TopologyLogicalTaskEntity)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

