/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.TopologyHostRequestEntity;
import id.onyx.obdp.server.orm.entities.TopologyLogicalTaskEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.Collection;

@Entity
@Table(name="topology_host_task")
@TableGenerator(name="topology_host_task_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="topology_host_task_id_seq", initialValue=0)
@NamedQueries(value={@NamedQuery(name="TopologyHostTaskEntity.findByHostRequest", query="SELECT req FROM TopologyHostTaskEntity req WHERE req.topologyHostRequestEntity.id = :hostRequestId"), @NamedQuery(name="TopologyLogicalTaskEntity.findHostRequestIdsByHostTaskIds", query="SELECT DISTINCT tht.hostRequestId from TopologyHostTaskEntity tht WHERE tht.id IN :hostTaskIds"), @NamedQuery(name="TopologyHostTaskEntity.removeByTaskIds", query="DELETE FROM TopologyHostTaskEntity tht WHERE tht.id IN :hostTaskIds")})
public class TopologyHostTaskEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="topology_host_task_id_generator")
    @Column(name="id", nullable=false, updatable=false)
    private Long id;
    @Column(name="type", length=255, nullable=false)
    private String type;
    @Column(name="host_request_id", nullable=false, insertable=false, updatable=false)
    private Long hostRequestId;
    @ManyToOne
    @JoinColumn(name="host_request_id", referencedColumnName="id", nullable=false)
    private TopologyHostRequestEntity topologyHostRequestEntity;
    @OneToMany(mappedBy="topologyHostTaskEntity", cascade={CascadeType.ALL})
    private Collection<TopologyLogicalTaskEntity> topologyLogicalTaskEntities;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getHostRequestId() {
        return this.hostRequestId;
    }

    public void setHostRequestId(Long hostRequestId) {
        this.hostRequestId = hostRequestId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public TopologyHostRequestEntity getTopologyHostRequestEntity() {
        return this.topologyHostRequestEntity;
    }

    public void setTopologyHostRequestEntity(TopologyHostRequestEntity topologyHostRequestEntity) {
        this.topologyHostRequestEntity = topologyHostRequestEntity;
    }

    public Collection<TopologyLogicalTaskEntity> getTopologyLogicalTaskEntities() {
        return this.topologyLogicalTaskEntities;
    }

    public void setTopologyLogicalTaskEntities(Collection<TopologyLogicalTaskEntity> topologyLogicalTaskEntities) {
        this.topologyLogicalTaskEntities = topologyLogicalTaskEntities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologyHostTaskEntity that = (TopologyHostTaskEntity)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

