/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.actionmanager.CommandExecutionType;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.orm.entities.HostRoleCommandEntity;
import id.onyx.obdp.server.orm.entities.RequestEntity;
import id.onyx.obdp.server.orm.entities.RoleSuccessCriteriaEntity;
import id.onyx.obdp.server.orm.entities.StageEntityPK;
import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

@Entity
@Table(name="stage")
@IdClass(value=StageEntityPK.class)
@NamedQueries(value={@NamedQuery(name="StageEntity.findFirstStageByStatus", query="SELECT stage.requestId, MIN(stage.stageId) from StageEntity stage, HostRoleCommandEntity hrc WHERE hrc.status IN :statuses AND hrc.stageId = stage.stageId AND hrc.requestId = stage.requestId GROUP by stage.requestId ORDER BY stage.requestId"), @NamedQuery(name="StageEntity.findByRequestIdAndCommandStatuses", query="SELECT stage from StageEntity stage WHERE stage.status IN :statuses AND stage.requestId = :requestId ORDER BY stage.stageId"), @NamedQuery(name="StageEntity.removeByRequestStageIds", query="DELETE FROM StageEntity stage WHERE stage.stageId = :stageId AND stage.requestId = :requestId")})
public class StageEntity {
    @Basic
    @Column(name="cluster_id", updatable=false, nullable=false)
    private Long clusterId = -1L;
    @Id
    @Column(name="request_id", insertable=false, updatable=false, nullable=false)
    private Long requestId;
    @Id
    @Column(name="stage_id", insertable=true, updatable=false, nullable=false)
    private Long stageId = 0L;
    @Basic
    @Column(name="skippable", nullable=false)
    private Integer skippable = 0;
    @Basic
    @Column(name="supports_auto_skip_failure", nullable=false)
    private Integer supportsAutoSkipOnFailure = 0;
    @Basic
    @Column(name="log_info")
    private String logInfo = "";
    @Basic
    @Column(name="request_context")
    private String requestContext = "";
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="command_execution_type", nullable=false)
    private CommandExecutionType commandExecutionType = CommandExecutionType.STAGE;
    @Column(name="command_params")
    @Basic(fetch=FetchType.LAZY)
    private byte[] commandParamsStage;
    @Basic
    @Column(name="host_params")
    private byte[] hostParamsStage;
    @Column(name="status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private HostRoleStatus status = HostRoleStatus.PENDING;
    @Column(name="display_status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private HostRoleStatus displayStatus = HostRoleStatus.PENDING;
    @ManyToOne
    @JoinColumn(name="request_id", referencedColumnName="request_id", nullable=false)
    private RequestEntity request;
    @OneToMany(mappedBy="stage", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private Collection<HostRoleCommandEntity> hostRoleCommands;
    @OneToMany(mappedBy="stage", cascade={CascadeType.REMOVE})
    private Collection<RoleSuccessCriteriaEntity> roleSuccessCriterias;

    public Long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public Long getRequestId() {
        return this.requestId;
    }

    public void setRequestId(Long requestId) {
        this.requestId = requestId;
    }

    public Long getStageId() {
        return this.stageId;
    }

    public void setStageId(Long stageId) {
        this.stageId = stageId;
    }

    public String getLogInfo() {
        return StringUtils.defaultString((String)this.logInfo);
    }

    public void setLogInfo(String logInfo) {
        this.logInfo = logInfo;
    }

    public String getRequestContext() {
        return StringUtils.defaultString((String)this.requestContext);
    }

    public String getCommandParamsStage() {
        return this.commandParamsStage == null ? new String() : new String(this.commandParamsStage);
    }

    public void setCommandParamsStage(String commandParamsStage) {
        this.commandParamsStage = commandParamsStage.getBytes();
    }

    public String getHostParamsStage() {
        return this.hostParamsStage == null ? new String() : new String(this.hostParamsStage);
    }

    public void setHostParamsStage(String hostParamsStage) {
        this.hostParamsStage = hostParamsStage.getBytes();
    }

    public void setRequestContext(String requestContext) {
        if (requestContext != null) {
            this.requestContext = requestContext;
        }
    }

    public CommandExecutionType getCommandExecutionType() {
        return this.commandExecutionType;
    }

    public void setCommandExecutionType(CommandExecutionType commandExecutionType) {
        this.commandExecutionType = commandExecutionType;
    }

    public HostRoleStatus getStatus() {
        return this.status;
    }

    public void setStatus(HostRoleStatus status) {
        this.status = status;
    }

    public HostRoleStatus getDisplayStatus() {
        return this.displayStatus;
    }

    public void setDisplayStatus(HostRoleStatus displayStatus) {
        this.displayStatus = displayStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StageEntity that = (StageEntity)o;
        if (this.clusterId != null ? !this.clusterId.equals(that.clusterId) : that.clusterId != null) {
            return false;
        }
        if (this.requestId != null ? !this.requestId.equals(that.requestId) : that.requestId != null) {
            return false;
        }
        if (this.stageId != null ? !this.stageId.equals(that.stageId) : that.stageId != null) {
            return false;
        }
        return !(this.requestContext == null ? that.requestContext != null : !this.requestContext.equals(that.requestContext));
    }

    public int hashCode() {
        int result = this.clusterId != null ? this.clusterId.hashCode() : 0;
        result = 31 * result + (this.requestId != null ? this.requestId.hashCode() : 0);
        result = 31 * result + (this.stageId != null ? this.stageId.hashCode() : 0);
        result = 31 * result + (this.requestContext != null ? this.requestContext.hashCode() : 0);
        return result;
    }

    public Collection<HostRoleCommandEntity> getHostRoleCommands() {
        return this.hostRoleCommands;
    }

    public void setHostRoleCommands(Collection<HostRoleCommandEntity> hostRoleCommands) {
        this.hostRoleCommands = hostRoleCommands;
    }

    public Collection<RoleSuccessCriteriaEntity> getRoleSuccessCriterias() {
        return this.roleSuccessCriterias;
    }

    public void setRoleSuccessCriterias(Collection<RoleSuccessCriteriaEntity> roleSuccessCriterias) {
        this.roleSuccessCriterias = roleSuccessCriterias;
    }

    public RequestEntity getRequest() {
        return this.request;
    }

    public void setRequest(RequestEntity request) {
        this.request = request;
    }

    public boolean isSkippable() {
        return this.skippable != 0;
    }

    public void setSkippable(boolean skippable) {
        this.skippable = skippable ? 1 : 0;
    }

    public boolean isAutoSkipOnFailureSupported() {
        return this.supportsAutoSkipOnFailure != 0;
    }

    public void setAutoSkipFailureSupported(boolean supportsAutoSkipOnFailure) {
        this.supportsAutoSkipOnFailure = supportsAutoSkipOnFailure ? 1 : 0;
    }
}

