/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.QueryHint;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;

@Entity
@Table(name="stack", uniqueConstraints={@UniqueConstraint(columnNames={"stack_name", "stack_version"})})
@TableGenerator(name="stack_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="stack_id_seq", initialValue=0)
@NamedQueries(value={@NamedQuery(name="StackEntity.findByMpack", query="SELECT stack FROM StackEntity stack where stack.mpackId = :mpackId"), @NamedQuery(name="StackEntity.findAll", query="SELECT stack FROM StackEntity stack"), @NamedQuery(name="StackEntity.findByNameAndVersion", query="SELECT stack FROM StackEntity stack WHERE stack.stackName = :stackName AND stack.stackVersion = :stackVersion", hints={@QueryHint(name="eclipselink.query-results-cache", value="True"), @QueryHint(name="eclipselink.query-results-cache.size", value="100")})})
public class StackEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="stack_id_generator")
    @Column(name="stack_id", nullable=false, updatable=false)
    private Long stackId;
    @Column(name="stack_name", length=255, nullable=false)
    private String stackName;
    @Column(name="stack_version", length=255, nullable=false)
    private String stackVersion;
    @Column(name="mpack_id")
    private Long mpackId;

    public Long getMpackId() {
        return this.mpackId;
    }

    public void setMpackId(Long mpackId) {
        this.mpackId = mpackId;
    }

    public Long getStackId() {
        return this.stackId;
    }

    public String getStackName() {
        return this.stackName;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    public String getStackVersion() {
        return this.stackVersion;
    }

    public void setStackVersion(String stackVersion) {
        this.stackVersion = stackVersion;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StackEntity that = (StackEntity)object;
        return !(this.stackId != null ? !this.stackId.equals(that.stackId) : that.stackId != null);
    }

    public int hashCode() {
        int result = null != this.stackId ? this.stackId.hashCode() : 0;
        return result;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName());
        buffer.append("{");
        buffer.append("id=").append(this.stackId);
        buffer.append(", name=").append(this.stackName);
        buffer.append(", version=").append(this.stackVersion);
        buffer.append(", mpack_id=").append(this.mpackId);
        buffer.append("}");
        return buffer.toString();
    }
}

