/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.ClusterServiceEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.orm.entities.ServiceDesiredStateEntityPK;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.State;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.util.Objects;
import org.apache.commons.lang.builder.EqualsBuilder;

@IdClass(value=ServiceDesiredStateEntityPK.class)
@Table(name="servicedesiredstate")
@Entity
public class ServiceDesiredStateEntity {
    @Id
    @Column(name="cluster_id", nullable=false, insertable=false, updatable=false, length=10)
    private Long clusterId;
    @Id
    @Column(name="service_name", nullable=false, insertable=false, updatable=false)
    private String serviceName;
    @Column(name="desired_state", nullable=false, insertable=true, updatable=true)
    @Enumerated(value=EnumType.STRING)
    private State desiredState = State.INIT;
    @Basic
    @Column(name="desired_host_role_mapping", nullable=false, insertable=true, updatable=true, length=10)
    private int desiredHostRoleMapping = 0;
    @Column(name="maintenance_state", nullable=false, insertable=true, updatable=true)
    @Enumerated(value=EnumType.STRING)
    private MaintenanceState maintenanceState = MaintenanceState.OFF;
    @Column(name="credential_store_enabled", nullable=false, insertable=true, updatable=true)
    private short credentialStoreEnabled = 0;
    @OneToOne
    @JoinColumns(value={@JoinColumn(name="cluster_id", referencedColumnName="cluster_id", nullable=false), @JoinColumn(name="service_name", referencedColumnName="service_name", nullable=false)})
    private ClusterServiceEntity clusterServiceEntity;
    @ManyToOne
    @JoinColumn(name="desired_repo_version_id", unique=false, nullable=false, insertable=true, updatable=true)
    private RepositoryVersionEntity desiredRepositoryVersion;

    public Long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public State getDesiredState() {
        return this.desiredState;
    }

    public void setDesiredState(State desiredState) {
        this.desiredState = desiredState;
    }

    public int getDesiredHostRoleMapping() {
        return this.desiredHostRoleMapping;
    }

    public void setDesiredHostRoleMapping(int desiredHostRoleMapping) {
        this.desiredHostRoleMapping = desiredHostRoleMapping;
    }

    public StackEntity getDesiredStack() {
        return this.desiredRepositoryVersion.getStack();
    }

    public MaintenanceState getMaintenanceState() {
        return this.maintenanceState;
    }

    public void setMaintenanceState(MaintenanceState state) {
        this.maintenanceState = state;
    }

    public boolean isCredentialStoreEnabled() {
        return this.credentialStoreEnabled != 0;
    }

    public void setCredentialStoreEnabled(boolean credentialStoreEnabled) {
        this.credentialStoreEnabled = (short)(credentialStoreEnabled ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceDesiredStateEntity that = (ServiceDesiredStateEntity)o;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)this.clusterId, (Object)that.clusterId);
        equalsBuilder.append((Object)this.desiredState, (Object)that.desiredState);
        equalsBuilder.append(this.desiredHostRoleMapping, that.desiredHostRoleMapping);
        equalsBuilder.append((Object)this.serviceName, (Object)that.serviceName);
        equalsBuilder.append((Object)this.desiredRepositoryVersion, (Object)that.desiredRepositoryVersion);
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clusterId, this.serviceName, this.desiredState, this.desiredHostRoleMapping, this.desiredRepositoryVersion});
    }

    public ClusterServiceEntity getClusterServiceEntity() {
        return this.clusterServiceEntity;
    }

    public void setClusterServiceEntity(ClusterServiceEntity clusterServiceEntity) {
        this.clusterServiceEntity = clusterServiceEntity;
    }

    public RepositoryVersionEntity getDesiredRepositoryVersion() {
        return this.desiredRepositoryVersion;
    }

    public void setDesiredRepositoryVersion(RepositoryVersionEntity desiredRepositoryVersion) {
        this.desiredRepositoryVersion = desiredRepositoryVersion;
    }
}

