/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.ClusterConfigEntity;
import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import jakarta.persistence.Basic;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.List;

@Entity
@Table(name="serviceconfig")
@TableGenerator(name="service_config_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="service_config_id_seq", initialValue=1)
@NamedQueries(value={@NamedQuery(name="ServiceConfigEntity.findAll", query="SELECT serviceConfig FROM ServiceConfigEntity serviceConfig WHERE serviceConfig.clusterId=:clusterId ORDER BY serviceConfig.version DESC"), @NamedQuery(name="ServiceConfigEntity.findNextServiceConfigVersion", query="SELECT COALESCE(MAX(serviceConfig.version), 0) + 1 AS nextVersion FROM ServiceConfigEntity serviceConfig WHERE serviceConfig.serviceName=:serviceName AND serviceConfig.clusterId=:clusterId"), @NamedQuery(name="ServiceConfigEntity.findAllServiceConfigsByStack", query="SELECT serviceConfig FROM ServiceConfigEntity serviceConfig WHERE serviceConfig.clusterId=:clusterId AND serviceConfig.stack=:stack AND serviceConfig.serviceName=:serviceName"), @NamedQuery(name="ServiceConfigEntity.findLatestServiceConfigsByStack", query="SELECT serviceConfig FROM ServiceConfigEntity serviceConfig WHERE serviceConfig.clusterId = :clusterId AND (serviceConfig.groupId = null OR serviceConfig.groupId IN (SELECT cg.groupId from ConfigGroupEntity cg)) AND serviceConfig.version = (SELECT MAX(serviceConfig2.version) FROM ServiceConfigEntity serviceConfig2 WHERE serviceConfig2.clusterId= :clusterId AND serviceConfig2.stack = :stack AND serviceConfig2.serviceName = serviceConfig.serviceName)"), @NamedQuery(name="ServiceConfigEntity.findLatestServiceConfigsByService", query="SELECT scv FROM ServiceConfigEntity scv WHERE scv.clusterId = :clusterId AND scv.serviceName = :serviceName AND (scv.groupId = null OR scv.groupId IN (SELECT cg.groupId from ConfigGroupEntity cg)) AND scv.version = (SELECT MAX(scv2.version) FROM ServiceConfigEntity scv2 WHERE (scv2.serviceName = :serviceName AND scv2.clusterId = :clusterId) AND (scv2.groupId = scv.groupId OR (scv2.groupId IS NULL AND scv.groupId IS NULL)))"), @NamedQuery(name="ServiceConfigEntity.findLatestServiceConfigsByServiceDefaultGroup", query="SELECT scv FROM ServiceConfigEntity scv WHERE scv.clusterId = :clusterId AND scv.serviceName = :serviceName AND scv.groupId = null AND scv.version = (SELECT MAX(scv2.version) FROM ServiceConfigEntity scv2 WHERE (scv2.serviceName = :serviceName AND scv2.clusterId = :clusterId) AND scv2.groupId IS NULL)"), @NamedQuery(name="ServiceConfigEntity.findLatestServiceConfigsByCluster", query="SELECT scv FROM ServiceConfigEntity scv WHERE scv.clusterId = :clusterId AND scv.serviceConfigId IN (SELECT MAX(scv1.serviceConfigId) FROM ServiceConfigEntity scv1 WHERE (scv1.clusterId = :clusterId) AND (scv1.groupId IS NULL) GROUP BY scv1.serviceName)")})
public class ServiceConfigEntity {
    @Id
    @Column(name="service_config_id")
    @GeneratedValue(strategy=GenerationType.TABLE, generator="service_config_id_generator")
    private Long serviceConfigId;
    @Basic
    @Column(name="cluster_id", insertable=false, updatable=false, nullable=false)
    private Long clusterId;
    @Basic
    @Column(name="service_name", nullable=false)
    private String serviceName;
    @Basic
    @Column(name="group_id", nullable=true)
    private Long groupId;
    @Basic
    @Column(name="version", nullable=false)
    private Long version;
    @Basic
    @Column(name="create_timestamp", nullable=false)
    private Long createTimestamp = System.currentTimeMillis();
    @Basic
    @Column(name="user_name")
    private String user = "_db";
    @Basic
    @Column(name="note")
    private String note;
    @ElementCollection
    @CollectionTable(name="serviceconfighosts", joinColumns={@JoinColumn(name="service_config_id")})
    @Column(name="host_id")
    private List<Long> hostIds;
    @ManyToMany
    @JoinTable(name="serviceconfigmapping", joinColumns={@JoinColumn(name="service_config_id", referencedColumnName="service_config_id")}, inverseJoinColumns={@JoinColumn(name="config_id", referencedColumnName="config_id")})
    private List<ClusterConfigEntity> clusterConfigEntities;
    @ManyToOne
    @JoinColumn(name="cluster_id", referencedColumnName="cluster_id", nullable=false)
    private ClusterEntity clusterEntity;
    @OneToOne
    @JoinColumn(name="stack_id", unique=false, nullable=false, insertable=true, updatable=true)
    private StackEntity stack;

    public Long getServiceConfigId() {
        return this.serviceConfigId;
    }

    public void setServiceConfigId(Long serviceConfigId) {
        this.serviceConfigId = serviceConfigId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Long getCreateTimestamp() {
        return this.createTimestamp;
    }

    public void setCreateTimestamp(Long create_timestamp) {
        this.createTimestamp = create_timestamp;
    }

    public List<ClusterConfigEntity> getClusterConfigEntities() {
        return this.clusterConfigEntities;
    }

    public void setClusterConfigEntities(List<ClusterConfigEntity> clusterConfigEntities) {
        this.clusterConfigEntities = clusterConfigEntities;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public ClusterEntity getClusterEntity() {
        return this.clusterEntity;
    }

    public void setClusterEntity(ClusterEntity clusterEntity) {
        this.clusterEntity = clusterEntity;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public List<Long> getHostIds() {
        return this.hostIds;
    }

    public void setHostIds(List<Long> hostIds) {
        this.hostIds = hostIds;
    }

    public StackEntity getStack() {
        return this.stack;
    }

    public void setStack(StackEntity stack) {
        this.stack = stack;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.serviceConfigId == null ? 0 : this.serviceConfigId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceConfigEntity other = (ServiceConfigEntity)obj;
        return !(this.serviceConfigId == null ? other.serviceConfigId != null : !this.serviceConfigId.equals(other.serviceConfigId));
    }
}

