/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.orm.entities.ServiceComponentDesiredStateEntity;
import id.onyx.obdp.server.state.RepositoryVersionState;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.Objects;

@Entity
@Table(name="servicecomponent_version")
@TableGenerator(name="servicecomponent_version_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="servicecomponent_version_id_seq", initialValue=0)
@NamedQueries(value={@NamedQuery(name="ServiceComponentVersionEntity.findByComponent", query="SELECT version FROM ServiceComponentVersionEntity version WHERE version.m_serviceComponentDesiredStateEntity.clusterId = :clusterId AND version.m_serviceComponentDesiredStateEntity.serviceName = :serviceName AND version.m_serviceComponentDesiredStateEntity.componentName = :componentName"), @NamedQuery(name="ServiceComponentVersionEntity.findByComponentAndVersion", query="SELECT version FROM ServiceComponentVersionEntity version WHERE version.m_serviceComponentDesiredStateEntity.clusterId = :clusterId AND version.m_serviceComponentDesiredStateEntity.serviceName = :serviceName AND version.m_serviceComponentDesiredStateEntity.componentName = :componentName AND version.m_repositoryVersion.version = :repoVersion")})
public class ServiceComponentVersionEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="servicecomponent_version_id_generator")
    @Column(name="id", nullable=false, updatable=false)
    private long m_id;
    @ManyToOne(optional=false, cascade={CascadeType.MERGE})
    @JoinColumn(name="component_id", referencedColumnName="id", nullable=false)
    private ServiceComponentDesiredStateEntity m_serviceComponentDesiredStateEntity;
    @ManyToOne
    @JoinColumn(name="repo_version_id", referencedColumnName="repo_version_id", nullable=false)
    private RepositoryVersionEntity m_repositoryVersion;
    @Column(name="state", nullable=false, insertable=true, updatable=true)
    @Enumerated(value=EnumType.STRING)
    private RepositoryVersionState m_state = RepositoryVersionState.CURRENT;
    @Column(name="user_name", nullable=false, insertable=true, updatable=true)
    private String userName;

    public ServiceComponentDesiredStateEntity getServiceComponentDesiredState() {
        return this.m_serviceComponentDesiredStateEntity;
    }

    public void setServiceComponentDesiredState(ServiceComponentDesiredStateEntity serviceComponentDesiredStateEntity) {
        this.m_serviceComponentDesiredStateEntity = serviceComponentDesiredStateEntity;
    }

    public void setRepositoryVersion(RepositoryVersionEntity repositoryVersion) {
        this.m_repositoryVersion = repositoryVersion;
    }

    public RepositoryVersionEntity getRepositoryVersion() {
        return this.m_repositoryVersion;
    }

    public long getId() {
        return this.m_id;
    }

    public RepositoryVersionState getState() {
        return this.m_state;
    }

    public void setState(RepositoryVersionState state) {
        this.m_state = state;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String name) {
        this.userName = name;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.m_id, this.m_repositoryVersion, this.m_serviceComponentDesiredStateEntity, this.m_state});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceComponentVersionEntity other = (ServiceComponentVersionEntity)obj;
        return Objects.equals(this.m_id, other.m_id) && Objects.equals(this.m_repositoryVersion, other.m_repositoryVersion) && Objects.equals(this.m_serviceComponentDesiredStateEntity, other.m_serviceComponentDesiredStateEntity) && Objects.equals((Object)this.m_state, (Object)other.m_state);
    }
}

