/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.ClusterServiceEntity;
import id.onyx.obdp.server.orm.entities.HostComponentDesiredStateEntity;
import id.onyx.obdp.server.orm.entities.HostComponentStateEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.orm.entities.ServiceComponentVersionEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.state.RepositoryVersionState;
import id.onyx.obdp.server.state.State;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang.builder.EqualsBuilder;

@Entity
@Table(name="servicecomponentdesiredstate", uniqueConstraints={@UniqueConstraint(name="unq_scdesiredstate_name", columnNames={"component_name", "service_name", "cluster_id"})})
@TableGenerator(name="servicecomponentdesiredstate_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="servicecomponentdesiredstate_id_seq", initialValue=0)
@NamedQueries(value={@NamedQuery(name="ServiceComponentDesiredStateEntity.findByName", query="SELECT scds FROM ServiceComponentDesiredStateEntity scds WHERE scds.clusterId = :clusterId AND scds.serviceName = :serviceName AND scds.componentName = :componentName")})
public class ServiceComponentDesiredStateEntity {
    @Id
    @Column(name="id", nullable=false, insertable=true, updatable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="servicecomponentdesiredstate_id_generator")
    private Long id;
    @Column(name="cluster_id", nullable=false, insertable=false, updatable=false, length=10)
    private Long clusterId;
    @Column(name="service_name", nullable=false, insertable=false, updatable=false)
    private String serviceName;
    @Column(name="component_name", nullable=false, insertable=true, updatable=true)
    private String componentName;
    @Column(name="desired_state", nullable=false, insertable=true, updatable=true)
    @Enumerated(value=EnumType.STRING)
    private State desiredState = State.INIT;
    @Column(name="recovery_enabled", nullable=false, insertable=true, updatable=true)
    private Integer recoveryEnabled = 0;
    @Column(name="repo_state", nullable=false, insertable=true, updatable=true)
    @Enumerated(value=EnumType.STRING)
    private RepositoryVersionState repoState = RepositoryVersionState.NOT_REQUIRED;
    @OneToOne
    @JoinColumn(name="desired_repo_version_id", unique=false, nullable=false, insertable=true, updatable=true)
    private RepositoryVersionEntity desiredRepositoryVersion;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="cluster_id", referencedColumnName="cluster_id", nullable=false), @JoinColumn(name="service_name", referencedColumnName="service_name", nullable=false)})
    private ClusterServiceEntity clusterServiceEntity;
    @OneToMany(mappedBy="serviceComponentDesiredStateEntity")
    private Collection<HostComponentStateEntity> hostComponentStateEntities;
    @OneToMany(mappedBy="serviceComponentDesiredStateEntity")
    private Collection<HostComponentDesiredStateEntity> hostComponentDesiredStateEntities;
    @OneToMany(mappedBy="m_serviceComponentDesiredStateEntity", cascade={CascadeType.ALL})
    private Collection<ServiceComponentVersionEntity> serviceComponentVersions;

    public Long getId() {
        return this.id;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public State getDesiredState() {
        return this.desiredState;
    }

    public void setDesiredState(State desiredState) {
        this.desiredState = desiredState;
    }

    public RepositoryVersionEntity getDesiredRepositoryVersion() {
        return this.desiredRepositoryVersion;
    }

    public void setDesiredRepositoryVersion(RepositoryVersionEntity desiredRepositoryVersion) {
        this.desiredRepositoryVersion = desiredRepositoryVersion;
    }

    public StackEntity getDesiredStack() {
        return this.desiredRepositoryVersion.getStack();
    }

    public String getDesiredVersion() {
        return this.desiredRepositoryVersion.getVersion();
    }

    public void addVersion(ServiceComponentVersionEntity versionEntity) {
        if (null == this.serviceComponentVersions) {
            this.serviceComponentVersions = new ArrayList<ServiceComponentVersionEntity>();
        }
        this.serviceComponentVersions.add(versionEntity);
        versionEntity.setServiceComponentDesiredState(this);
    }

    public Collection<ServiceComponentVersionEntity> getVersions() {
        return this.serviceComponentVersions;
    }

    public boolean isRecoveryEnabled() {
        return this.recoveryEnabled != 0;
    }

    public void setRecoveryEnabled(boolean recoveryEnabled) {
        this.recoveryEnabled = !recoveryEnabled ? 0 : 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceComponentDesiredStateEntity that = (ServiceComponentDesiredStateEntity)o;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)this.id, (Object)that.id);
        equalsBuilder.append((Object)this.clusterId, (Object)that.clusterId);
        equalsBuilder.append((Object)this.componentName, (Object)that.componentName);
        equalsBuilder.append((Object)this.desiredState, (Object)that.desiredState);
        equalsBuilder.append((Object)this.serviceName, (Object)that.serviceName);
        equalsBuilder.append((Object)this.desiredRepositoryVersion, (Object)that.desiredRepositoryVersion);
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.clusterId, this.serviceName, this.componentName, this.desiredState, this.desiredRepositoryVersion});
    }

    public ClusterServiceEntity getClusterServiceEntity() {
        return this.clusterServiceEntity;
    }

    public void setClusterServiceEntity(ClusterServiceEntity clusterServiceEntity) {
        this.clusterServiceEntity = clusterServiceEntity;
    }

    public Collection<HostComponentStateEntity> getHostComponentStateEntities() {
        return this.hostComponentStateEntities;
    }

    public void setHostComponentStateEntities(Collection<HostComponentStateEntity> hostComponentStateEntities) {
        this.hostComponentStateEntities = hostComponentStateEntities;
    }

    public Collection<HostComponentDesiredStateEntity> getHostComponentDesiredStateEntities() {
        return this.hostComponentDesiredStateEntities;
    }

    public void setHostComponentDesiredStateEntities(Collection<HostComponentDesiredStateEntity> hostComponentDesiredStateEntities) {
        this.hostComponentDesiredStateEntities = hostComponentDesiredStateEntities;
    }

    public void setRepositoryState(RepositoryVersionState state) {
        this.repoState = state;
    }

    public RepositoryVersionState getRepositoryState() {
        return this.repoState;
    }
}

