/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.PrivilegeEntity;
import id.onyx.obdp.server.orm.entities.ResourceTypeEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.Collection;
import java.util.HashSet;

@Table(name="adminresource")
@Entity
@TableGenerator(name="resource_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="resource_id_seq", initialValue=2)
public class ResourceEntity {
    public static final long OBDP_RESOURCE_ID = 1L;
    @Id
    @Column(name="resource_id")
    @GeneratedValue(strategy=GenerationType.TABLE, generator="resource_id_generator")
    private Long id;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="resource_type_id", referencedColumnName="resource_type_id", nullable=false)})
    private ResourceTypeEntity resourceType;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="resource")
    private Collection<PrivilegeEntity> privileges = new HashSet<PrivilegeEntity>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public ResourceTypeEntity getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceTypeEntity resourceType) {
        this.resourceType = resourceType;
    }

    public Collection<PrivilegeEntity> getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(Collection<PrivilegeEntity> privileges) {
        this.privileges = privileges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceEntity that = (ResourceEntity)o;
        return !(this.id == null ? that.id != null : !this.id.equals(that.id)) && !(this.resourceType == null ? that.resourceType != null : !this.resourceType.equals(that.resourceType));
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.resourceType != null ? this.resourceType.hashCode() : 0);
        return result;
    }
}

