/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.RequestEntity;
import id.onyx.obdp.server.orm.entities.RequestScheduleBatchRequestEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.Collection;
import java.util.List;

@Table(name="requestschedule")
@Entity
@NamedQueries(value={@NamedQuery(name="allReqSchedules", query="SELECT reqSchedule FROM RequestScheduleEntity reqSchedule"), @NamedQuery(name="reqScheduleByStatus", query="SELECT reqSchedule FROM RequestScheduleEntity reqSchedule WHERE reqSchedule.status=:status")})
@TableGenerator(name="schedule_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="requestschedule_id_seq", initialValue=1)
public class RequestScheduleEntity {
    @Id
    @Column(name="schedule_id", nullable=false, insertable=true, updatable=true)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="schedule_id_generator")
    private long scheduleId;
    @Column(name="cluster_id", insertable=false, updatable=false, nullable=false)
    private Long clusterId;
    @Column(name="description")
    private String description;
    @Column(name="status")
    private String status;
    @Column(name="batch_separation_seconds")
    private Integer batchSeparationInSeconds;
    @Column(name="batch_toleration_limit")
    private Integer batchTolerationLimit;
    @Column(name="batch_toleration_limit_per_batch")
    private Integer batchTolerationLimitPerBatch;
    @Column(name="pause_after_first_batch")
    private Boolean pauseAfterFirstBatch;
    @Column(name="authenticated_user_id")
    private Integer authenticatedUserId;
    @Column(name="create_user")
    private String createUser;
    @Column(name="create_timestamp")
    private Long createTimestamp;
    @Column(name="update_user")
    protected String updateUser;
    @Column(name="update_timestamp")
    private Long updateTimestamp;
    @Column(name="minutes")
    private String minutes;
    @Column(name="hours")
    private String hours;
    @Column(name="days_of_month")
    private String daysOfMonth;
    @Column(name="month")
    private String month;
    @Column(name="day_of_week")
    private String dayOfWeek;
    @Column(name="yearToSchedule")
    private String year;
    @Column(name="starttime")
    private String startTime;
    @Column(name="endtime")
    private String endTime;
    @Column(name="last_execution_status")
    private String lastExecutionStatus;
    @ManyToOne
    @JoinColumn(name="cluster_id", referencedColumnName="cluster_id", nullable=false)
    private ClusterEntity clusterEntity;
    @OneToMany(mappedBy="requestScheduleEntity", cascade={CascadeType.ALL})
    private Collection<RequestScheduleBatchRequestEntity> requestScheduleBatchRequestEntities;
    @OneToMany(mappedBy="requestScheduleEntity")
    private List<RequestEntity> requestEntities;

    public long getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(long scheduleId) {
        this.scheduleId = scheduleId;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Integer getBatchSeparationInSeconds() {
        return this.batchSeparationInSeconds;
    }

    public void setBatchSeparationInSeconds(Integer batchSeparationInSeconds) {
        this.batchSeparationInSeconds = batchSeparationInSeconds;
    }

    public Integer getBatchTolerationLimit() {
        return this.batchTolerationLimit;
    }

    public void setBatchTolerationLimit(Integer batchTolerationLimit) {
        this.batchTolerationLimit = batchTolerationLimit;
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public Long getCreateTimestamp() {
        return this.createTimestamp;
    }

    public void setCreateTimestamp(Long createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public String getUpdateUser() {
        return this.updateUser;
    }

    public void setUpdateUser(String updateUser) {
        this.updateUser = updateUser;
    }

    public Long getUpdateTimestamp() {
        return this.updateTimestamp;
    }

    public void setUpdateTimestamp(Long updateTimestamp) {
        this.updateTimestamp = updateTimestamp;
    }

    public String getMinutes() {
        return this.minutes;
    }

    public void setMinutes(String minutes) {
        this.minutes = minutes;
    }

    public String getHours() {
        return this.hours;
    }

    public void setHours(String hours) {
        this.hours = hours;
    }

    public String getDaysOfMonth() {
        return this.daysOfMonth;
    }

    public void setDaysOfMonth(String daysOfMonth) {
        this.daysOfMonth = daysOfMonth;
    }

    public String getMonth() {
        return this.month;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public String getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(String dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getLastExecutionStatus() {
        return this.lastExecutionStatus;
    }

    public void setLastExecutionStatus(String lastExecutionStatus) {
        this.lastExecutionStatus = lastExecutionStatus;
    }

    public ClusterEntity getClusterEntity() {
        return this.clusterEntity;
    }

    public void setClusterEntity(ClusterEntity clusterEntity) {
        this.clusterEntity = clusterEntity;
    }

    public Collection<RequestScheduleBatchRequestEntity> getRequestScheduleBatchRequestEntities() {
        return this.requestScheduleBatchRequestEntities;
    }

    public void setRequestScheduleBatchRequestEntities(Collection<RequestScheduleBatchRequestEntity> requestScheduleBatchRequestEntities) {
        this.requestScheduleBatchRequestEntities = requestScheduleBatchRequestEntities;
    }

    public List<RequestEntity> getRequestEntities() {
        return this.requestEntities;
    }

    public void setRequestEntities(List<RequestEntity> requestEntities) {
        this.requestEntities = requestEntities;
    }

    public Integer getAuthenticatedUserId() {
        return this.authenticatedUserId;
    }

    public void setAuthenticatedUserId(Integer authenticatedUser) {
        this.authenticatedUserId = authenticatedUser;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestScheduleEntity that = (RequestScheduleEntity)o;
        if (this.scheduleId != that.scheduleId) {
            return false;
        }
        return this.clusterId.equals(that.clusterId);
    }

    public int hashCode() {
        int result = (int)(this.scheduleId ^ this.scheduleId >>> 32);
        result = 31 * result + this.clusterId.hashCode();
        return result;
    }

    public Integer getBatchTolerationLimitPerBatch() {
        return this.batchTolerationLimitPerBatch;
    }

    public void setBatchTolerationLimitPerBatch(Integer batchTolerationLimitPerBatch) {
        this.batchTolerationLimitPerBatch = batchTolerationLimitPerBatch;
    }

    public Boolean isPauseAfterFirstBatch() {
        return this.pauseAfterFirstBatch;
    }

    public void setPauseAfterFirstBatch(Boolean pauseAfterFirstBatch) {
        this.pauseAfterFirstBatch = pauseAfterFirstBatch;
    }
}

