/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.RequestScheduleBatchRequestEntityPK;
import id.onyx.obdp.server.orm.entities.RequestScheduleEntity;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;

@IdClass(value=RequestScheduleBatchRequestEntityPK.class)
@Entity
@Table(name="requestschedulebatchrequest")
@NamedQueries(value={@NamedQuery(name="findByScheduleId", query="SELECT batchreqs FROM RequestScheduleBatchRequestEntity  batchreqs WHERE batchreqs.scheduleId=:id")})
public class RequestScheduleBatchRequestEntity {
    @Id
    @Column(name="schedule_id", nullable=false, insertable=true, updatable=true)
    private Long scheduleId;
    @Id
    @Column(name="batch_id", nullable=false, insertable=true, updatable=true)
    private Long batchId;
    @Column(name="request_id")
    private Long requestId;
    @Column(name="request_type", length=255)
    private String requestType;
    @Column(name="request_uri", length=1024)
    private String requestUri;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Column(name="request_body")
    private byte[] requestBody;
    @Column(name="request_status", length=255)
    private String requestStatus;
    @Column(name="return_code")
    private Integer returnCode;
    @Column(name="return_message", length=2000)
    private String returnMessage;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="schedule_id", referencedColumnName="schedule_id", nullable=false, insertable=false, updatable=false)})
    private RequestScheduleEntity requestScheduleEntity;

    public Long getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(Long scheduleId) {
        this.scheduleId = scheduleId;
    }

    public Long getBatchId() {
        return this.batchId;
    }

    public void setBatchId(Long batchId) {
        this.batchId = batchId;
    }

    public Long getRequestId() {
        return this.requestId;
    }

    public void setRequestId(Long requestId) {
        this.requestId = requestId;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public void setRequestUri(String requestUri) {
        this.requestUri = requestUri;
    }

    public byte[] getRequestBody() {
        return this.requestBody;
    }

    public String getRequestBodyAsString() {
        return this.requestBody != null ? new String(this.requestBody) : null;
    }

    public void setRequestBody(byte[] requestBody) {
        this.requestBody = requestBody;
    }

    public void setRequestBody(String requestBodyStr) {
        if (requestBodyStr != null) {
            this.requestBody = requestBodyStr.getBytes();
        }
    }

    public String getRequestStatus() {
        return this.requestStatus;
    }

    public void setRequestStatus(String requestStatus) {
        this.requestStatus = requestStatus;
    }

    public Integer getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(Integer returnCode) {
        this.returnCode = returnCode;
    }

    public String getReturnMessage() {
        return this.returnMessage;
    }

    public void setReturnMessage(String returnMessage) {
        this.returnMessage = returnMessage;
    }

    public RequestScheduleEntity getRequestScheduleEntity() {
        return this.requestScheduleEntity;
    }

    public void setRequestScheduleEntity(RequestScheduleEntity requestScheduleEntity) {
        this.requestScheduleEntity = requestScheduleEntity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestScheduleBatchRequestEntity that = (RequestScheduleBatchRequestEntity)o;
        if (!this.batchId.equals(that.batchId)) {
            return false;
        }
        return this.scheduleId.equals(that.scheduleId);
    }

    public int hashCode() {
        int result = this.scheduleId.hashCode();
        result = 31 * result + this.batchId.hashCode();
        return result;
    }

    public String toString() {
        return "RequestScheduleBatchRequestEntity{scheduleId=" + this.scheduleId + ", batchId=" + this.batchId + ", requestId=" + this.requestId + ", requestType='" + this.requestType + "', requestUri='" + this.requestUri + "', requestStatus='" + this.requestStatus + "', returnCode=" + this.returnCode + ", returnMessage='" + this.returnMessage + "'}";
    }
}

