/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.actionmanager.RequestType;
import id.onyx.obdp.server.orm.entities.RequestOperationLevelEntity;
import id.onyx.obdp.server.orm.entities.RequestResourceFilterEntity;
import id.onyx.obdp.server.orm.entities.RequestScheduleEntity;
import id.onyx.obdp.server.orm.entities.StageEntity;
import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.util.Collection;

@Table(name="request")
@Entity
@NamedQueries(value={@NamedQuery(name="RequestEntity.findRequestStageIdsInClusterBeforeDate", query="SELECT NEW id.onyx.obdp.server.orm.dao.RequestDAO.StageEntityPK(request.requestId, stage.stageId) FROM RequestEntity request JOIN StageEntity stage ON request.requestId = stage.requestId WHERE request.clusterId = :clusterId AND request.createTime <= :beforeDate"), @NamedQuery(name="RequestEntity.removeByRequestIds", query="DELETE FROM RequestEntity request WHERE request.requestId IN :requestIds")})
public class RequestEntity {
    @Column(name="request_id")
    @Id
    private Long requestId;
    @Column(name="cluster_id", updatable=false, nullable=false)
    @Basic
    private Long clusterId;
    @Column(name="request_schedule_id", updatable=false, insertable=false, nullable=true)
    @Basic
    private Long requestScheduleId;
    @Column(name="request_context")
    @Basic
    private String requestContext;
    @Column(name="command_name")
    @Basic
    private String commandName;
    @Column(name="cluster_host_info")
    @Basic(fetch=FetchType.LAZY)
    private byte[] clusterHostInfo;
    @Column(name="inputs")
    @Lob
    private byte[] inputs = new byte[0];
    @Column(name="request_type")
    @Enumerated(value=EnumType.STRING)
    private RequestType requestType;
    @Column(name="status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private HostRoleStatus status = HostRoleStatus.PENDING;
    @Column(name="display_status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private HostRoleStatus displayStatus = HostRoleStatus.PENDING;
    @Basic
    @Column(name="create_time", nullable=false)
    private Long createTime = System.currentTimeMillis();
    @Basic
    @Column(name="start_time", nullable=false)
    private Long startTime = -1L;
    @Basic
    @Column(name="end_time", nullable=false)
    private Long endTime = -1L;
    @Basic
    @Column(name="exclusive_execution", insertable=true, updatable=true, nullable=false)
    private Integer exclusive = 0;
    @Column(name="user_name")
    private String userName;
    @OneToMany(mappedBy="request", cascade={CascadeType.REMOVE})
    private Collection<StageEntity> stages;
    @OneToMany(mappedBy="requestEntity", cascade={CascadeType.ALL})
    private Collection<RequestResourceFilterEntity> resourceFilterEntities;
    @OneToOne(mappedBy="requestEntity", cascade={CascadeType.ALL})
    private RequestOperationLevelEntity requestOperationLevel;
    @ManyToOne(cascade={CascadeType.MERGE})
    @JoinColumn(name="request_schedule_id", referencedColumnName="schedule_id")
    private RequestScheduleEntity requestScheduleEntity;

    public Long getRequestId() {
        return this.requestId;
    }

    public void setRequestId(Long id) {
        this.requestId = id;
    }

    public String getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(String request_context) {
        this.requestContext = request_context;
    }

    public Collection<StageEntity> getStages() {
        return this.stages;
    }

    public void setStages(Collection<StageEntity> stages) {
        this.stages = stages;
    }

    public String getClusterHostInfo() {
        return this.clusterHostInfo == null ? "{}" : new String(this.clusterHostInfo);
    }

    public void setClusterHostInfo(String clusterHostInfo) {
        this.clusterHostInfo = clusterHostInfo.getBytes();
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public Boolean isExclusive() {
        return this.exclusive != 0;
    }

    public void setExclusive(Boolean exclusive) {
        this.exclusive = exclusive == false ? 0 : 1;
    }

    public String getInputs() {
        return this.inputs != null ? new String(this.inputs) : null;
    }

    public void setInputs(String inputs) {
        this.inputs = inputs != null ? inputs.getBytes() : null;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public void setRequestType(RequestType requestType) {
        this.requestType = requestType;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public Collection<RequestResourceFilterEntity> getResourceFilterEntities() {
        return this.resourceFilterEntities;
    }

    public void setResourceFilterEntities(Collection<RequestResourceFilterEntity> resourceFilterEntities) {
        this.resourceFilterEntities = resourceFilterEntities;
    }

    public RequestOperationLevelEntity getRequestOperationLevel() {
        return this.requestOperationLevel;
    }

    public void setRequestOperationLevel(RequestOperationLevelEntity operationLevel) {
        this.requestOperationLevel = operationLevel;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public void setCommandName(String commandName) {
        this.commandName = commandName;
    }

    public HostRoleStatus getStatus() {
        return this.status;
    }

    public void setStatus(HostRoleStatus status) {
        this.status = status;
    }

    public HostRoleStatus getDisplayStatus() {
        return this.displayStatus;
    }

    public void setDisplayStatus(HostRoleStatus displayStatus) {
        this.displayStatus = displayStatus;
    }

    public RequestScheduleEntity getRequestScheduleEntity() {
        return this.requestScheduleEntity;
    }

    public void setRequestScheduleEntity(RequestScheduleEntity requestScheduleEntity) {
        this.requestScheduleEntity = requestScheduleEntity;
    }

    public Long getRequestScheduleId() {
        return this.requestScheduleId;
    }

    public void setRequestScheduleId(Long scheduleId) {
        this.requestScheduleId = scheduleId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestEntity that = (RequestEntity)o;
        return !(this.requestId != null ? !this.requestId.equals(that.requestId) : that.requestId != null);
    }

    public int hashCode() {
        return this.requestId != null ? this.requestId.hashCode() : 0;
    }
}

