/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import com.google.common.base.MoreObjects;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.orm.entities.HostVersionEntity;
import id.onyx.obdp.server.orm.entities.RepoOsEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.repository.VersionDefinitionXml;
import id.onyx.obdp.spi.RepositoryType;
import id.onyx.obdp.spi.RepositoryVersion;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

@Entity
@Table(name="repo_version", uniqueConstraints={@UniqueConstraint(columnNames={"display_name"}), @UniqueConstraint(columnNames={"stack_id", "version"})})
@TableGenerator(name="repository_version_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="repo_version_id_seq")
@NamedQueries(value={@NamedQuery(name="repositoryVersionByDisplayName", query="SELECT repoversion FROM RepositoryVersionEntity repoversion WHERE repoversion.displayName=:displayname"), @NamedQuery(name="repositoryVersionByStack", query="SELECT repoversion FROM RepositoryVersionEntity repoversion WHERE repoversion.stack.stackName=:stackName AND repoversion.stack.stackVersion=:stackVersion"), @NamedQuery(name="repositoryVersionByStackAndType", query="SELECT repoversion FROM RepositoryVersionEntity repoversion WHERE repoversion.stack.stackName=:stackName AND repoversion.stack.stackVersion=:stackVersion AND repoversion.type=:type"), @NamedQuery(name="repositoryVersionByStackNameAndVersion", query="SELECT repoversion FROM RepositoryVersionEntity repoversion WHERE repoversion.stack.stackName=:stackName AND repoversion.version=:version"), @NamedQuery(name="repositoryVersionsFromDefinition", query="SELECT repoversion FROM RepositoryVersionEntity repoversion WHERE repoversion.versionXsd IS NOT NULL"), @NamedQuery(name="findRepositoryByVersion", query="SELECT repositoryVersion FROM RepositoryVersionEntity repositoryVersion WHERE repositoryVersion.version = :version ORDER BY repositoryVersion.id DESC"), @NamedQuery(name="findByServiceDesiredVersion", query="SELECT repositoryVersion FROM RepositoryVersionEntity repositoryVersion WHERE repositoryVersion IN (SELECT DISTINCT sd1.desiredRepositoryVersion FROM ServiceDesiredStateEntity sd1 WHERE sd1.desiredRepositoryVersion IN ?1)")})
@StaticallyInject
public class RepositoryVersionEntity {
    @Id
    @Column(name="repo_version_id")
    @GeneratedValue(strategy=GenerationType.TABLE, generator="repository_version_id_generator")
    private Long id;
    @OneToOne
    @JoinColumn(name="stack_id", nullable=false)
    private StackEntity stack;
    @Column(name="version")
    private String version;
    @Column(name="display_name")
    private String displayName;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="repositoryVersionEntity", orphanRemoval=true)
    private List<RepoOsEntity> repoOsEntities = new ArrayList<RepoOsEntity>();
    @OneToMany(cascade={CascadeType.REMOVE}, mappedBy="repositoryVersion")
    private Set<HostVersionEntity> hostVersionEntities;
    @Column(name="repo_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private RepositoryType type = RepositoryType.STANDARD;
    @Lob
    @Column(name="version_xml")
    private String versionXml;
    @Transient
    private VersionDefinitionXml versionDefinition = null;
    @Column(name="version_url")
    private String versionUrl;
    @Column(name="version_xsd")
    private String versionXsd;
    @Column(name="hidden", nullable=false)
    private short isHidden = 0;
    @Column(name="resolved", nullable=false)
    private short resolved = 0;
    @Column(name="legacy", nullable=false)
    private short isLegacy = 0;
    @ManyToOne
    @JoinColumn(name="parent_id")
    private RepositoryVersionEntity parent;
    @OneToMany(mappedBy="parent")
    private List<RepositoryVersionEntity> children;

    public RepositoryVersionEntity() {
    }

    public RepositoryVersionEntity(StackEntity stack, String version, String displayName, List<RepoOsEntity> repoOsEntities) {
        this.stack = stack;
        this.version = version;
        this.displayName = displayName;
        this.repoOsEntities = repoOsEntities;
        for (RepoOsEntity repoOsEntity : repoOsEntities) {
            repoOsEntity.setRepositoryVersionEntity(this);
        }
    }

    @PreUpdate
    @PrePersist
    public void removePrefixFromVersion() {
        String stackName = this.stack.getStackName();
        if (this.version.startsWith(stackName)) {
            this.version = this.version.substring(stackName.length() + 1);
        }
    }

    public void updateHostVersionEntityRelation(HostVersionEntity entity) {
        this.hostVersionEntities.add(entity);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public StackEntity getStack() {
        return this.stack;
    }

    public void setStack(StackEntity stack) {
        this.stack = stack;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
        if (null != version && null != this.stack && null != this.stack.getStackName()) {
            this.removePrefixFromVersion();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getStackName() {
        return this.getStackId().getStackName();
    }

    public String getStackVersion() {
        return this.getStackId().getStackVersion();
    }

    public StackId getStackId() {
        if (null == this.stack) {
            return null;
        }
        return new StackId(this.stack.getStackName(), this.stack.getStackVersion());
    }

    public RepositoryType getType() {
        return this.type;
    }

    public void setType(RepositoryType type) {
        this.type = type;
    }

    public String getVersionXml() {
        return this.versionXml;
    }

    public void setVersionXml(String xml) {
        this.versionXml = xml;
    }

    public String getVersionUrl() {
        return this.versionUrl;
    }

    public void setVersionUrl(String url) {
        this.versionUrl = url;
    }

    public String getVersionXsd() {
        return this.versionXsd;
    }

    public void setVersionXsd(String xsdLocation) {
        this.versionXsd = xsdLocation;
    }

    public VersionDefinitionXml getRepositoryXml() throws Exception {
        if (null == this.versionXsd) {
            return null;
        }
        if (null == this.versionDefinition) {
            this.versionDefinition = VersionDefinitionXml.load(this.getVersionXml());
        }
        return this.versionDefinition;
    }

    public int hashCode() {
        return Objects.hash(this.stack, this.version, this.displayName, this.repoOsEntities);
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        RepositoryVersionEntity that = (RepositoryVersionEntity)object;
        return com.google.common.base.Objects.equal((Object)this.stack, (Object)that.stack) && com.google.common.base.Objects.equal((Object)this.version, (Object)that.version) && com.google.common.base.Objects.equal((Object)this.displayName, (Object)that.displayName) && com.google.common.base.Objects.equal(this.repoOsEntities, that.repoOsEntities);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("stack", (Object)this.stack).add("version", (Object)this.version).add("type", (Object)this.type).add("hidden", this.isHidden == 1).toString();
    }

    public static boolean isVersionInStack(StackId stackId, String version) {
        if (null != version && !StringUtils.isBlank((String)version)) {
            Object leading;
            String[] leadingParts;
            String stackName = stackId.getStackName();
            if (version.startsWith(stackName + "-")) {
                version = version.substring(stackName.length() + 1);
            }
            if ((leadingParts = ((String)(leading = stackId.getStackVersion())).split("\\.")).length > 2) {
                leading = leadingParts[0] + "." + leadingParts[1];
            }
            return version.startsWith((String)leading);
        }
        return false;
    }

    public void setParent(RepositoryVersionEntity entity) {
        this.parent = entity;
        this.parent.children.add(this);
    }

    public List<RepositoryVersionEntity> getChildren() {
        return this.children;
    }

    public Long getParentId() {
        return null == this.parent ? null : this.parent.getId();
    }

    public boolean isHidden() {
        return this.isHidden != 0;
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = (short)(isHidden ? 1 : 0);
    }

    public boolean isResolved() {
        return this.resolved == 1;
    }

    @Deprecated
    public boolean isLegacy() {
        return this.isLegacy == 1;
    }

    @Deprecated
    public void setLegacy(boolean isLegacy) {
        this.isLegacy = isLegacy ? (short)1 : 0;
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved ? (short)1 : 0;
    }

    public List<RepoOsEntity> getRepoOsEntities() {
        return this.repoOsEntities;
    }

    public void addRepoOsEntities(List<RepoOsEntity> repoOsEntities) {
        this.repoOsEntities = repoOsEntities;
        for (RepoOsEntity repoOsEntity : repoOsEntities) {
            repoOsEntity.setRepositoryVersionEntity(this);
        }
    }

    public RepositoryVersion getRepositoryVersion() {
        return new RepositoryVersion(this.getId().longValue(), this.getStackName(), this.getStackVersion(), this.getStackId().getStackId(), this.getVersion(), this.getType());
    }
}

