/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.RepoDefinitionEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Entity
@Table(name="repo_os")
@TableGenerator(name="repo_os_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="repo_os_id_seq")
public class RepoOsEntity {
    @Id
    @Column(name="id", nullable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="repo_os_id_generator")
    private Long id;
    @Column(name="family")
    private String family;
    @Column(name="ambari_managed", nullable=false)
    private short ambariManaged = 1;
    @OneToMany(orphanRemoval=true, fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="repoOs")
    private List<RepoDefinitionEntity> repoDefinitionEntities = new ArrayList<RepoDefinitionEntity>();
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="repo_version_id", nullable=false)
    private RepositoryVersionEntity repositoryVersionEntity;

    public List<RepoDefinitionEntity> getRepoDefinitionEntities() {
        return this.repoDefinitionEntities;
    }

    public void addRepoDefinitionEntities(List<RepoDefinitionEntity> repoDefinitionEntities) {
        this.repoDefinitionEntities.addAll(repoDefinitionEntities);
        for (RepoDefinitionEntity repoDefinitionEntity : repoDefinitionEntities) {
            repoDefinitionEntity.setRepoOs(this);
        }
    }

    public void addRepoDefinition(RepoDefinitionEntity repoDefinition) {
        this.repoDefinitionEntities.add(repoDefinition);
        repoDefinition.setRepoOs(this);
    }

    public RepositoryVersionEntity getRepositoryVersionEntity() {
        return this.repositoryVersionEntity;
    }

    public void setRepositoryVersionEntity(RepositoryVersionEntity repositoryVersionEntity) {
        this.repositoryVersionEntity = repositoryVersionEntity;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public boolean isAmbariManaged() {
        return this.ambariManaged == 1;
    }

    public void setAmbariManaged(boolean ambariManaged) {
        this.ambariManaged = (short)(ambariManaged ? 1 : 0);
    }

    public int hashCode() {
        return Objects.hash(this.family, this.ambariManaged, this.repoDefinitionEntities);
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        RepoOsEntity that = (RepoOsEntity)object;
        return com.google.common.base.Objects.equal((Object)this.ambariManaged, (Object)that.ambariManaged) && com.google.common.base.Objects.equal((Object)this.family, (Object)that.family) && com.google.common.base.Objects.equal(this.repoDefinitionEntities, that.repoDefinitionEntities);
    }
}

