/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.RepoOsEntity;
import id.onyx.obdp.server.state.stack.RepoTag;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@Entity
@Table(name="repo_definition")
@TableGenerator(name="repo_definition_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="repo_definition_id_seq")
public class RepoDefinitionEntity {
    @Id
    @Column(name="id", nullable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="repo_definition_id_generator")
    private Long id;
    @Enumerated(value=EnumType.STRING)
    @ElementCollection(targetClass=RepoTag.class)
    @CollectionTable(name="repo_tags", joinColumns={@JoinColumn(name="repo_definition_id")})
    @Column(name="tag")
    private Set<RepoTag> repoTags = new HashSet<RepoTag>();
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="repo_os_id", nullable=false)
    private RepoOsEntity repoOs;
    @Column(name="repo_name", nullable=false)
    private String repoName;
    @Column(name="repo_id", nullable=false)
    private String repoID;
    @Column(name="base_url", nullable=false)
    private String baseUrl;
    @Column(name="mirrors")
    private String mirrors;
    @Column(name="distribution")
    private String distribution;
    @Column(name="components")
    private String components;
    @Column(name="unique_repo", nullable=false)
    private short unique = 0;
    @ElementCollection(targetClass=String.class)
    @CollectionTable(name="repo_applicable_services", joinColumns={@JoinColumn(name="repo_definition_id")})
    @Column(name="service_name")
    private List<String> applicableServices = new LinkedList<String>();

    public String getDistribution() {
        return this.distribution;
    }

    public void setDistribution(String distribution) {
        this.distribution = distribution;
    }

    public RepoOsEntity getRepoOs() {
        return this.repoOs;
    }

    public void setRepoOs(RepoOsEntity repoOs) {
        this.repoOs = repoOs;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public void setRepoName(String repoName) {
        this.repoName = repoName;
    }

    public String getRepoID() {
        return this.repoID;
    }

    public void setRepoID(String repoID) {
        this.repoID = repoID;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getMirrors() {
        return this.mirrors;
    }

    public void setMirrors(String mirrors) {
        this.mirrors = mirrors;
    }

    public List<String> getApplicableServices() {
        return this.applicableServices;
    }

    public void setApplicableServices(List<String> applicableServices) {
        this.applicableServices = applicableServices;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getComponents() {
        return this.components;
    }

    public void setComponents(String components) {
        this.components = components;
    }

    public boolean isUnique() {
        return this.unique == 1;
    }

    public void setUnique(boolean unique) {
        this.unique = (short)(unique ? 1 : 0);
    }

    public Set<RepoTag> getTags() {
        return this.repoTags;
    }

    public void setTags(Set<RepoTag> repoTags) {
        this.repoTags = repoTags;
    }

    public int hashCode() {
        return Objects.hash(this.repoTags, this.repoName, this.repoID, this.baseUrl, this.mirrors, this.distribution, this.components, this.unique, this.applicableServices);
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        RepoDefinitionEntity that = (RepoDefinitionEntity)object;
        return com.google.common.base.Objects.equal((Object)this.unique, (Object)that.unique) && com.google.common.base.Objects.equal(this.repoTags, that.repoTags) && com.google.common.base.Objects.equal((Object)this.repoName, (Object)that.repoName) && com.google.common.base.Objects.equal((Object)this.repoID, (Object)that.repoID) && com.google.common.base.Objects.equal((Object)this.baseUrl, (Object)that.baseUrl) && com.google.common.base.Objects.equal((Object)this.mirrors, (Object)that.mirrors) && com.google.common.base.Objects.equal((Object)this.distribution, (Object)that.distribution) && com.google.common.base.Objects.equal((Object)this.components, (Object)that.components) && com.google.common.base.Objects.equal(this.applicableServices, that.applicableServices);
    }
}

