/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.RemoteOBDPClusterServiceEntity;
import id.onyx.obdp.server.view.DefaultMasker;
import id.onyx.obdp.view.MaskException;
import id.onyx.obdp.view.Masker;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Table(name="remoteambaricluster")
@TableGenerator(name="remote_cluster_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="remote_cluster_id_seq", initialValue=1)
@NamedQueries(value={@NamedQuery(name="allRemoteAmbariClusters", query="SELECT remoteAmbariCluster FROM RemoteOBDPClusterEntity remoteambaricluster"), @NamedQuery(name="remoteAmbariClusterByName", query="SELECT remoteAmbariCluster FROM RemoteOBDPClusterEntity remoteAmbariCluster WHERE remoteAmbariCluster.name=:clusterName"), @NamedQuery(name="remoteAmbariClusterById", query="SELECT remoteAmbariCluster FROM RemoteOBDPClusterEntity remoteAmbariCluster WHERE remoteAmbariCluster.id=:clusterId")})
@Entity
public class RemoteOBDPClusterEntity {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteOBDPClusterEntity.class);
    @Id
    @Column(name="cluster_id", nullable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="remote_cluster_id_generator")
    private Long id;
    @Column(name="name", nullable=false, insertable=true, updatable=true)
    private String name;
    @Column(name="url", nullable=false, insertable=true, updatable=true)
    private String url;
    @Column(name="username", nullable=false, insertable=true, updatable=true)
    private String username;
    @Column(name="password", nullable=false, insertable=true, updatable=true)
    private String password;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="cluster")
    private Collection<RemoteOBDPClusterServiceEntity> services;
    private static Masker masker = new DefaultMasker();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        try {
            return masker.unmask(this.password);
        }
        catch (MaskException e) {
            LOG.error("Unable to unmask password for Remote Cluster : " + this.name, (Throwable)e);
            return null;
        }
    }

    public void setPassword(String password) throws MaskException {
        this.password = masker.mask(password);
    }

    public Collection<RemoteOBDPClusterServiceEntity> getServices() {
        return this.services;
    }

    public void setServices(Collection<RemoteOBDPClusterServiceEntity> services) {
        this.services = services;
    }
}

