/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;

@Table(name="adminprincipaltype")
@Entity
@TableGenerator(name="principal_type_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="principal_type_id_seq", initialValue=100)
@NamedQueries(value={@NamedQuery(name="PrincipalTypeEntity.findByName", query="SELECT p FROM PrincipalTypeEntity p WHERE p.name = :name")})
public class PrincipalTypeEntity {
    public static final int USER_PRINCIPAL_TYPE = 1;
    public static final int GROUP_PRINCIPAL_TYPE = 2;
    public static final int ROLE_PRINCIPAL_TYPE = 8;
    public static final String USER_PRINCIPAL_TYPE_NAME = PrincipalType.USER.toString();
    public static final String GROUP_PRINCIPAL_TYPE_NAME = PrincipalType.GROUP.toString();
    public static final String ROLE_PRINCIPAL_TYPE_NAME = PrincipalType.ROLE.toString();
    @Id
    @Column(name="principal_type_id")
    @GeneratedValue(strategy=GenerationType.TABLE, generator="principal_type_id_generator")
    private Integer id;
    @Column(name="principal_type_name")
    private String name;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrincipalTypeEntity that = (PrincipalTypeEntity)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public static enum PrincipalType {
        USER,
        GROUP,
        ROLE;

    }
}

