/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.PrincipalTypeEntity;
import id.onyx.obdp.server.orm.entities.PrivilegeEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.HashSet;
import java.util.Set;

@Table(name="adminprincipal")
@Entity
@TableGenerator(name="principal_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="principal_id_seq", initialValue=100, allocationSize=500)
@NamedQueries(value={@NamedQuery(name="principalByPrivilegeId", query="SELECT principal FROM PrincipalEntity principal JOIN principal.privileges privilege WHERE privilege.permission.id=:permission_id"), @NamedQuery(name="principalByPrincipalType", query="SELECT principal FROM PrincipalEntity principal WHERE principal.principalType.name = :principal_type")})
public class PrincipalEntity {
    @Id
    @Column(name="principal_id")
    @GeneratedValue(strategy=GenerationType.TABLE, generator="principal_id_generator")
    private Long id;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="principal_type_id", referencedColumnName="principal_type_id", nullable=false)})
    private PrincipalTypeEntity principalType;
    @OneToMany(mappedBy="principal")
    private Set<PrivilegeEntity> privileges = new HashSet<PrivilegeEntity>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public PrincipalTypeEntity getPrincipalType() {
        return this.principalType;
    }

    public void setPrincipalType(PrincipalTypeEntity principalType) {
        this.principalType = principalType;
    }

    public Set<PrivilegeEntity> getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(Set<PrivilegeEntity> privileges) {
        this.privileges = privileges;
    }

    public void removePrivilege(PrivilegeEntity privilege) {
        this.privileges.remove(privilege);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrincipalEntity that = (PrincipalEntity)o;
        return this.id.equals(that.id) && !(this.principalType == null ? that.principalType != null : !this.principalType.equals(that.principalType));
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.principalType != null ? this.principalType.hashCode() : 0);
        return result;
    }
}

