/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.PrincipalEntity;
import id.onyx.obdp.server.orm.entities.ResourceTypeEntity;
import id.onyx.obdp.server.orm.entities.RoleAuthorizationEntity;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

@Table(name="adminpermission")
@Entity
@TableGenerator(name="permission_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="permission_id_seq", initialValue=100)
@NamedQueries(value={@NamedQuery(name="PermissionEntity.findByName", query="SELECT p FROM PermissionEntity p WHERE p.permissionName = :permissionName"), @NamedQuery(name="PermissionEntity.findByPrincipals", query="SELECT p FROM PermissionEntity p WHERE p.principal IN :principalList")})
public class PermissionEntity {
    public static final int OBDP_ADMINISTRATOR_PERMISSION = 1;
    public static final int CLUSTER_USER_PERMISSION = 2;
    public static final int CLUSTER_ADMINISTRATOR_PERMISSION = 3;
    public static final int VIEW_USER_PERMISSION = 4;
    public static final String OBDP_ADMINISTRATOR_PERMISSION_NAME = "OBDP.ADMINISTRATOR";
    public static final String CLUSTER_ADMINISTRATOR_PERMISSION_NAME = "CLUSTER.ADMINISTRATOR";
    public static final String CLUSTER_OPERATOR_PERMISSION_NAME = "CLUSTER.OPERATOR";
    public static final String SERVICE_ADMINISTRATOR_PERMISSION_NAME = "SERVICE.ADMINISTRATOR";
    public static final String SERVICE_OPERATOR_PERMISSION_NAME = "SERVICE.OPERATOR";
    public static final String CLUSTER_USER_PERMISSION_NAME = "CLUSTER.USER";
    public static final String VIEW_USER_PERMISSION_NAME = "VIEW.USER";
    @Id
    @Column(name="permission_id")
    @GeneratedValue(strategy=GenerationType.TABLE, generator="permission_id_generator")
    private Integer id;
    @Column(name="permission_name")
    private String permissionName;
    @Column(name="permission_label")
    private String permissionLabel;
    @OneToOne
    @JoinColumns(value={@JoinColumn(name="principal_id", referencedColumnName="principal_id", nullable=false)})
    private PrincipalEntity principal;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="resource_type_id", referencedColumnName="resource_type_id", nullable=false)})
    private ResourceTypeEntity resourceType;
    @ManyToMany
    @JoinTable(name="permission_roleauthorization", joinColumns={@JoinColumn(name="permission_id")}, inverseJoinColumns={@JoinColumn(name="authorization_id")})
    private Set<RoleAuthorizationEntity> authorizations = new LinkedHashSet<RoleAuthorizationEntity>();
    @Column(name="sort_order", nullable=false)
    private Integer sortOrder = 1;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getPermissionName() {
        return this.permissionName;
    }

    public void setPermissionName(String permissionName) {
        this.permissionName = permissionName;
    }

    public String getPermissionLabel() {
        return this.permissionLabel;
    }

    public void setPermissionLabel(String permissionLabel) {
        this.permissionLabel = permissionLabel;
    }

    public PrincipalEntity getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(PrincipalEntity principal) {
        this.principal = principal;
    }

    public ResourceTypeEntity getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceTypeEntity resourceType) {
        this.resourceType = resourceType;
    }

    public Collection<RoleAuthorizationEntity> getAuthorizations() {
        return this.authorizations;
    }

    public void addAuthorization(RoleAuthorizationEntity roleAuthorization) {
        this.authorizations.add(roleAuthorization);
    }

    public void addAuthorizations(Collection<RoleAuthorization> roleAuthorizations) {
        for (RoleAuthorization roleAuthorization : roleAuthorizations) {
            this.addAuthorization(PermissionEntity.createRoleAuthorizationEntity(roleAuthorization));
        }
    }

    private static RoleAuthorizationEntity createRoleAuthorizationEntity(RoleAuthorization authorization) {
        RoleAuthorizationEntity roleAuthorizationEntity = new RoleAuthorizationEntity();
        roleAuthorizationEntity.setAuthorizationId(authorization.getId());
        roleAuthorizationEntity.setAuthorizationName(authorization.name());
        return roleAuthorizationEntity;
    }

    public Integer getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionEntity that = (PermissionEntity)o;
        return !((this.id == null ? that.id != null : !this.id.equals(that.id)) || (this.permissionName == null ? that.permissionName != null : !this.permissionName.equals(that.permissionName)) || (this.permissionLabel == null ? that.permissionLabel != null : !this.permissionLabel.equals(that.permissionLabel)) || (this.resourceType == null ? that.resourceType != null : !this.resourceType.equals(that.resourceType)) || (this.sortOrder == null ? that.sortOrder != null : !this.sortOrder.equals(that.sortOrder)) || (this.authorizations == null ? that.authorizations != null : !this.authorizations.equals(that.authorizations)));
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.permissionName != null ? this.permissionName.hashCode() : 0);
        result = 31 * result + (this.permissionLabel != null ? this.permissionLabel.hashCode() : 0);
        result = 31 * result + (this.resourceType != null ? this.resourceType.hashCode() : 0);
        result = 31 * result + (this.sortOrder != null ? this.sortOrder.hashCode() : 0);
        result = 31 * result + (this.authorizations != null ? this.authorizations.hashCode() : 0);
        return result;
    }
}

