/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.Objects;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Table(name="mpacks")
@Entity
@TableGenerator(name="mpack_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="mpack_id_seq", initialValue=1)
@NamedQueries(value={@NamedQuery(name="MpackEntity.findById", query="SELECT mpack FROM MpackEntity mpack where mpack.id = :id"), @NamedQuery(name="MpackEntity.findAll", query="SELECT mpack FROM MpackEntity mpack"), @NamedQuery(name="MpackEntity.findByNameVersion", query="SELECT mpack FROM MpackEntity mpack where mpack.mpackName = :mpackName and mpack.mpackVersion = :mpackVersion")})
public class MpackEntity {
    protected static final Logger LOG = LoggerFactory.getLogger(MpackEntity.class);
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="mpack_id_generator")
    @Column(name="id", nullable=false, updatable=false)
    private Long id;
    @Column(name="registry_id", nullable=true, insertable=true, updatable=false, length=10)
    private Long registryId;
    @Column(name="mpack_name", nullable=false, updatable=true)
    private String mpackName;
    @Column(name="mpack_version", nullable=false)
    private String mpackVersion;
    @Column(name="mpack_uri", nullable=false)
    private String mpackUri;

    public Long getId() {
        return this.id;
    }

    public Long getRegistryId() {
        return this.registryId;
    }

    public String getMpackName() {
        return this.mpackName;
    }

    public String getMpackVersion() {
        return this.mpackVersion;
    }

    public String getMpackUri() {
        return this.mpackUri;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setRegistryId(Long registryId) {
        this.registryId = registryId;
    }

    public void setMpackName(String mpackName) {
        this.mpackName = mpackName;
    }

    public void setMpackVersion(String mpackVersion) {
        this.mpackVersion = mpackVersion;
    }

    public void setMpackUri(String mpackUri) {
        this.mpackUri = mpackUri;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MpackEntity that = (MpackEntity)object;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)this.id, (Object)that.id);
        equalsBuilder.append((Object)this.mpackName, (Object)that.mpackName);
        equalsBuilder.append((Object)this.mpackVersion, (Object)that.mpackVersion);
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.mpackName, this.mpackVersion);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("MpackEntity{");
        buffer.append("id=").append(this.id);
        if (null != this.registryId) {
            buffer.append(", registryId=").append(this.registryId);
        }
        buffer.append(", mpackName=").append(this.mpackName);
        buffer.append(", mpackVersion=").append(this.mpackVersion);
        buffer.append(", mpackUri=").append(this.mpackUri);
        buffer.append("}");
        return buffer.toString();
    }
}

