/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.GroupEntity;
import id.onyx.obdp.server.orm.entities.UserEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;

@Entity
@Table(name="members", uniqueConstraints={@UniqueConstraint(columnNames={"group_id", "user_id"})})
@NamedQueries(value={@NamedQuery(name="memberByUserAndGroup", query="SELECT memberEnt FROM MemberEntity memberEnt where lower(memberEnt.user.userName)=:username AND lower(memberEnt.group.groupName)=:groupname")})
@TableGenerator(name="member_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="member_id_seq", initialValue=1, allocationSize=500)
public class MemberEntity {
    @Id
    @Column(name="member_id")
    @GeneratedValue(strategy=GenerationType.TABLE, generator="member_id_generator")
    private Integer memberId;
    @ManyToOne
    @JoinColumn(name="group_id")
    private GroupEntity group;
    @ManyToOne
    @JoinColumn(name="user_id")
    private UserEntity user;

    public Integer getMemberId() {
        return this.memberId;
    }

    public void setMemberId(Integer memberId) {
        this.memberId = memberId;
    }

    public GroupEntity getGroup() {
        return this.group;
    }

    public void setGroup(GroupEntity group) {
        this.group = group;
    }

    public UserEntity getUser() {
        return this.user;
    }

    public void setUser(UserEntity user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemberEntity that = (MemberEntity)o;
        if (this.memberId != null ? !this.memberId.equals(that.memberId) : that.memberId != null) {
            return false;
        }
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public int hashCode() {
        int result = this.memberId != null ? this.memberId.hashCode() : 0;
        result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        return result;
    }
}

