/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import java.util.List;

public class LdapSyncSpecEntity {
    private PrincipalType principalType;
    private SyncType syncType;
    private List<String> principalNames;
    private boolean postProcessExistingUsers;

    public LdapSyncSpecEntity(PrincipalType principalType, SyncType syncType, List<String> principalNames, boolean postProcessExistingUsers) {
        this.principalType = principalType;
        this.syncType = syncType;
        this.principalNames = principalNames;
        this.postProcessExistingUsers = postProcessExistingUsers;
        assert (principalNames != null);
        if (syncType == SyncType.SPECIFIC) {
            if (principalNames.isEmpty()) {
                throw new IllegalArgumentException("Missing principal names for " + syncType + " sync-type.");
            }
        } else if (!principalNames.isEmpty()) {
            throw new IllegalArgumentException("Principal names should not be specified for " + syncType + " sync-type.");
        }
    }

    public PrincipalType getPrincipalType() {
        return this.principalType;
    }

    public SyncType getSyncType() {
        return this.syncType;
    }

    public List<String> getPrincipalNames() {
        return this.principalNames;
    }

    public boolean getPostProcessExistingUsers() {
        return this.postProcessExistingUsers;
    }

    public static enum PrincipalType {
        USERS,
        GROUPS;


        public static PrincipalType valueOfIgnoreCase(String type) {
            return PrincipalType.valueOf(type.toUpperCase());
        }
    }

    public static enum SyncType {
        ALL,
        EXISTING,
        SPECIFIC;


        public static SyncType valueOfIgnoreCase(String type) {
            return SyncType.valueOf(type.toUpperCase());
        }
    }
}

