/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import com.google.common.base.Objects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.entities.KerberosKeytabEntity;
import id.onyx.obdp.server.orm.entities.KerberosKeytabServiceMappingEntity;
import id.onyx.obdp.server.orm.entities.KerberosPrincipalEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.QueryHint;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Entity
@Table(name="kerberos_keytab_principal")
@TableGenerator(name="kkp_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="kkp_id_seq")
@NamedQueries(value={@NamedQuery(name="KerberosKeytabPrincipalEntity.findAll", query="SELECT kkpe FROM KerberosKeytabPrincipalEntity kkpe"), @NamedQuery(name="KerberosKeytabPrincipalEntity.findByHostAndKeytab", query="SELECT kkpe FROM KerberosKeytabPrincipalEntity kkpe WHERE kkpe.hostId=:hostId AND kkpe.keytabPath=:keytabPath"), @NamedQuery(name="KerberosKeytabPrincipalEntity.findByPrincipal", query="SELECT kkpe FROM KerberosKeytabPrincipalEntity kkpe WHERE kkpe.principalName=:principalName"), @NamedQuery(name="KerberosKeytabPrincipalEntity.findByHost", query="SELECT kkpe FROM KerberosKeytabPrincipalEntity kkpe WHERE kkpe.hostId=:hostId"), @NamedQuery(name="KerberosKeytabPrincipalEntity.findByPrincipalAndHost", query="SELECT kkpe FROM KerberosKeytabPrincipalEntity kkpe WHERE kkpe.hostId=:hostId AND kkpe.principalName=:principalName", hints={@QueryHint(name="eclipselink.query-results-cache", value="true"), @QueryHint(name="eclipselink.query-results-cache.size", value="500")}), @NamedQuery(name="KerberosKeytabPrincipalEntity.findByHostKeytabAndPrincipal", query="SELECT kkpe FROM KerberosKeytabPrincipalEntity kkpe WHERE kkpe.hostId=:hostId AND kkpe.keytabPath=:keytabPath AND kkpe.principalName=:principalName"), @NamedQuery(name="KerberosKeytabPrincipalEntity.findByKeytabAndPrincipalNullHost", query="SELECT kkpe FROM KerberosKeytabPrincipalEntity kkpe WHERE kkpe.principalName=:principalName AND kkpe.keytabPath=:keytabPath AND kkpe.hostId IS NULL")})
public class KerberosKeytabPrincipalEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="kkp_id_generator")
    @Column(name="kkp_id")
    private Long kkpId;
    @Column(name="keytab_path", updatable=false, nullable=false)
    private String keytabPath;
    @Column(name="principal_name", updatable=false, nullable=false)
    private String principalName;
    @Column(name="host_id")
    private Long hostId;
    @Column(name="is_distributed", nullable=false)
    private Integer isDistributed = 0;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="keytab_path", referencedColumnName="keytab_path", updatable=false, nullable=false, insertable=false)
    private KerberosKeytabEntity kerberosKeytabEntity;
    @ManyToOne
    @JoinColumn(name="host_id", referencedColumnName="host_id", updatable=false, insertable=false)
    private HostEntity hostEntity;
    @ManyToOne
    @JoinColumn(name="principal_name", referencedColumnName="principal_name", updatable=false, nullable=false, insertable=false)
    private KerberosPrincipalEntity kerberosPrincipalEntity;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="kerberosKeytabPrincipalEntity", orphanRemoval=true, fetch=FetchType.EAGER)
    private List<KerberosKeytabServiceMappingEntity> serviceMapping = new ArrayList<KerberosKeytabServiceMappingEntity>();

    public KerberosKeytabPrincipalEntity() {
    }

    public KerberosKeytabPrincipalEntity(KerberosKeytabEntity kerberosKeytabEntity, HostEntity hostEntity, KerberosPrincipalEntity kerberosPrincipalEntity) {
        this.setKerberosKeytabEntity(kerberosKeytabEntity);
        this.setHostEntity(hostEntity);
        this.setKerberosPrincipalEntity(kerberosPrincipalEntity);
    }

    public Long getKkpId() {
        return this.kkpId;
    }

    public void setKkpId(Long kkpId) {
        this.kkpId = kkpId;
    }

    public Boolean isDistributed() {
        return this.isDistributed == 1;
    }

    public void setDistributed(Boolean isDistributed) {
        this.isDistributed = isDistributed != false ? 1 : 0;
    }

    public KerberosKeytabEntity getKerberosKeytabEntity() {
        return this.kerberosKeytabEntity;
    }

    public void setKerberosKeytabEntity(KerberosKeytabEntity kke) {
        this.kerberosKeytabEntity = kke;
        if (kke != null) {
            this.keytabPath = kke.getKeytabPath();
        }
    }

    public HostEntity getHostEntity() {
        return this.hostEntity;
    }

    public void setHostEntity(HostEntity hostEntity) {
        this.hostEntity = hostEntity;
        if (hostEntity != null) {
            this.hostId = hostEntity.getHostId();
        }
    }

    public KerberosPrincipalEntity getKerberosPrincipalEntity() {
        return this.kerberosPrincipalEntity;
    }

    public void setKerberosPrincipalEntity(KerberosPrincipalEntity kerberosPrincipalEntity) {
        this.kerberosPrincipalEntity = kerberosPrincipalEntity;
        if (kerberosPrincipalEntity != null) {
            this.principalName = kerberosPrincipalEntity.getPrincipalName();
        }
    }

    public String getKeytabPath() {
        return this.kerberosKeytabEntity != null ? this.kerberosKeytabEntity.getKeytabPath() : null;
    }

    public String getPrincipalName() {
        return this.kerberosPrincipalEntity != null ? this.kerberosPrincipalEntity.getPrincipalName() : null;
    }

    public Long getHostId() {
        return this.hostEntity != null ? this.hostEntity.getHostId() : null;
    }

    public String getHostName() {
        return this.hostEntity != null ? this.hostEntity.getHostName() : null;
    }

    public List<KerberosKeytabServiceMappingEntity> getServiceMapping() {
        return this.serviceMapping;
    }

    public void setServiceMapping(List<KerberosKeytabServiceMappingEntity> serviceMapping) {
        this.serviceMapping = serviceMapping == null ? Collections.emptyList() : new ArrayList<KerberosKeytabServiceMappingEntity>(serviceMapping);
    }

    public boolean putServiceMapping(String service, String component) {
        if (this.containsMapping(service, component)) {
            return false;
        }
        this.serviceMapping.add(new KerberosKeytabServiceMappingEntity(this, service, component));
        return true;
    }

    public Multimap<String, String> getServiceMappingAsMultimap() {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (KerberosKeytabServiceMappingEntity mappingEntity : this.serviceMapping) {
            result.put((Object)mappingEntity.getServiceName(), (Object)mappingEntity.getComponentName());
        }
        return result;
    }

    public boolean containsMapping(String serviceName, String componentName) {
        for (KerberosKeytabServiceMappingEntity mappingEntity : this.serviceMapping) {
            if (!Objects.equal((Object)mappingEntity.getComponentName(), (Object)componentName) || !Objects.equal((Object)mappingEntity.getServiceName(), (Object)serviceName)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KerberosKeytabPrincipalEntity that = (KerberosKeytabPrincipalEntity)o;
        return Objects.equal((Object)this.keytabPath, (Object)that.keytabPath) && Objects.equal((Object)this.principalName, (Object)that.principalName) && Objects.equal((Object)this.hostId, (Object)that.hostId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.keytabPath, this.principalName, this.hostId});
    }
}

