/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.KerberosKeytabPrincipalEntity;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.ResolvedKerberosKeytab;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.QueryHint;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.Collection;

@Entity
@Table(name="kerberos_keytab")
@NamedQueries(value={@NamedQuery(name="KerberosKeytabEntity.findAll", query="SELECT kk FROM KerberosKeytabEntity kk"), @NamedQuery(name="KerberosKeytabEntity.findByPrincipalAndHost", query="SELECT kk FROM KerberosKeytabEntity kk, KerberosKeytabPrincipalEntity kkp WHERE kkp.hostId=:hostId AND kkp.principalName=:principalName AND kkp.keytabPath = kk.keytabPath", hints={@QueryHint(name="eclipselink.query-results-cache", value="true"), @QueryHint(name="eclipselink.query-results-cache.size", value="500")}), @NamedQuery(name="KerberosKeytabEntity.findByPrincipalAndNullHost", query="SELECT kk FROM KerberosKeytabEntity kk JOIN kk.kerberosKeytabPrincipalEntities kkp WHERE kkp.hostId IS NULL AND kkp.principalName=:principalName")})
public class KerberosKeytabEntity {
    @Id
    @Column(name="keytab_path", updatable=false, nullable=false)
    private String keytabPath = null;
    @Column(name="owner_name")
    private String ownerName;
    @Column(name="owner_access")
    private String ownerAccess;
    @Column(name="group_name")
    private String groupName;
    @Column(name="group_access")
    private String groupAccess;
    @Column(name="is_ambari_keytab")
    private Integer isAmbariServerKeytab = 0;
    @Column(name="write_ambari_jaas")
    private Integer writeAmbariJaasFile = 0;
    @OneToMany(mappedBy="kerberosKeytabEntity", cascade={CascadeType.REMOVE}, fetch=FetchType.EAGER)
    private Collection<KerberosKeytabPrincipalEntity> kerberosKeytabPrincipalEntities = new ArrayList<KerberosKeytabPrincipalEntity>();

    public KerberosKeytabEntity() {
    }

    public KerberosKeytabEntity(String keytabPath) {
        this.setKeytabPath(keytabPath);
    }

    public KerberosKeytabEntity(ResolvedKerberosKeytab resolvedKerberosKeytab) {
        this.setKeytabPath(resolvedKerberosKeytab.getFile());
        this.setAmbariServerKeytab(resolvedKerberosKeytab.isAmbariServerKeytab());
        this.setWriteAmbariJaasFile(resolvedKerberosKeytab.isMustWriteAmbariJaasFile());
        this.setOwnerName(resolvedKerberosKeytab.getOwnerName());
        this.setOwnerAccess(resolvedKerberosKeytab.getOwnerAccess());
        this.setGroupName(resolvedKerberosKeytab.getGroupName());
        this.setGroupAccess(resolvedKerberosKeytab.getGroupAccess());
    }

    public String getKeytabPath() {
        return this.keytabPath;
    }

    public void setKeytabPath(String keytabPath) {
        this.keytabPath = keytabPath;
    }

    public Collection<KerberosKeytabPrincipalEntity> getKerberosKeytabPrincipalEntities() {
        return this.kerberosKeytabPrincipalEntities;
    }

    public void setKerberosKeytabPrincipalEntities(Collection<KerberosKeytabPrincipalEntity> kerberosKeytabPrincipalEntities) {
        this.kerberosKeytabPrincipalEntities = kerberosKeytabPrincipalEntities;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getOwnerAccess() {
        return this.ownerAccess;
    }

    public void setOwnerAccess(String ownerAccess) {
        this.ownerAccess = ownerAccess;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupAccess() {
        return this.groupAccess;
    }

    public void setGroupAccess(String groupAccess) {
        this.groupAccess = groupAccess;
    }

    public boolean isAmbariServerKeytab() {
        return this.isAmbariServerKeytab == 1;
    }

    public void setAmbariServerKeytab(boolean ambariServerKeytab) {
        this.isAmbariServerKeytab = ambariServerKeytab ? 1 : 0;
    }

    public boolean isWriteAmbariJaasFile() {
        return this.writeAmbariJaasFile == 1;
    }

    public void setWriteAmbariJaasFile(boolean writeAmbariJaasFile) {
        this.writeAmbariJaasFile = writeAmbariJaasFile ? 1 : 0;
    }

    public void addKerberosKeytabPrincipal(KerberosKeytabPrincipalEntity kerberosKeytabPrincipalEntity) {
        if (!this.kerberosKeytabPrincipalEntities.contains(kerberosKeytabPrincipalEntity)) {
            this.kerberosKeytabPrincipalEntities.add(kerberosKeytabPrincipalEntity);
        }
    }
}

