/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.state.RepositoryVersionState;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.util.Objects;

@Entity
@Table(name="host_version", uniqueConstraints={@UniqueConstraint(name="UQ_host_repo", columnNames={"host_id", "repo_version_id"})})
@TableGenerator(name="host_version_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="host_version_id_seq", initialValue=0)
@NamedQueries(value={@NamedQuery(name="hostVersionByClusterAndStackAndVersion", query="SELECT hostVersion FROM HostVersionEntity hostVersion JOIN hostVersion.hostEntity host JOIN host.clusterEntities clusters WHERE clusters.clusterName=:clusterName AND hostVersion.repositoryVersion.stack.stackName=:stackName AND hostVersion.repositoryVersion.stack.stackVersion=:stackVersion AND hostVersion.repositoryVersion.version=:version"), @NamedQuery(name="hostVersionByClusterAndHostname", query="SELECT hostVersion FROM HostVersionEntity hostVersion JOIN hostVersion.hostEntity host JOIN host.clusterEntities clusters WHERE clusters.clusterName=:clusterName AND hostVersion.hostEntity.hostName=:hostName"), @NamedQuery(name="hostVersionByHostname", query="SELECT hostVersion FROM HostVersionEntity hostVersion JOIN hostVersion.hostEntity host WHERE hostVersion.hostEntity.hostName=:hostName"), @NamedQuery(name="findByClusterAndState", query="SELECT hostVersion FROM HostVersionEntity hostVersion JOIN hostVersion.hostEntity host JOIN host.clusterEntities clusters WHERE clusters.clusterName=:clusterName AND hostVersion.state=:state"), @NamedQuery(name="findByCluster", query="SELECT hostVersion FROM HostVersionEntity hostVersion JOIN hostVersion.hostEntity host JOIN host.clusterEntities clusters WHERE clusters.clusterName=:clusterName"), @NamedQuery(name="hostVersionByClusterHostnameAndState", query="SELECT hostVersion FROM HostVersionEntity hostVersion JOIN hostVersion.hostEntity host JOIN host.clusterEntities clusters WHERE clusters.clusterName=:clusterName AND hostVersion.hostEntity.hostName=:hostName AND hostVersion.state=:state"), @NamedQuery(name="hostVersionByClusterStackVersionAndHostname", query="SELECT hostVersion FROM HostVersionEntity hostVersion JOIN hostVersion.hostEntity host JOIN host.clusterEntities clusters WHERE clusters.clusterName=:clusterName AND hostVersion.repositoryVersion.stack.stackName=:stackName AND hostVersion.repositoryVersion.stack.stackVersion=:stackVersion AND hostVersion.repositoryVersion.version=:version AND hostVersion.hostEntity.hostName=:hostName"), @NamedQuery(name="findHostVersionByClusterAndRepository", query="SELECT hostVersion FROM HostVersionEntity hostVersion JOIN hostVersion.hostEntity host JOIN host.clusterEntities clusters WHERE clusters.clusterId = :clusterId AND hostVersion.repositoryVersion = :repositoryVersion"), @NamedQuery(name="hostVersionByRepositoryAndStates", query="SELECT hostVersion FROM HostVersionEntity hostVersion WHERE hostVersion.repositoryVersion = :repositoryVersion AND hostVersion.state IN :states"), @NamedQuery(name="findByHostAndRepository", query="SELECT hostVersion FROM HostVersionEntity hostVersion WHERE hostVersion.hostEntity = :host AND hostVersion.repositoryVersion = :repositoryVersion")})
public class HostVersionEntity {
    @Id
    @Column(name="id", nullable=false, insertable=true, updatable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="host_version_id_generator")
    private Long id;
    @ManyToOne
    @JoinColumn(name="repo_version_id", referencedColumnName="repo_version_id", nullable=false)
    private RepositoryVersionEntity repositoryVersion;
    @Column(name="host_id", nullable=false, insertable=false, updatable=false)
    private Long hostId;
    @ManyToOne
    @JoinColumn(name="host_id", referencedColumnName="host_id", nullable=false)
    private HostEntity hostEntity;
    @Column(name="state", nullable=false, insertable=true, updatable=true)
    @Enumerated(value=EnumType.STRING)
    private RepositoryVersionState state;

    public HostVersionEntity() {
    }

    public HostVersionEntity(HostEntity hostEntity, RepositoryVersionEntity repositoryVersion, RepositoryVersionState state) {
        this.hostEntity = hostEntity;
        this.repositoryVersion = repositoryVersion;
        this.state = state;
    }

    public HostVersionEntity(HostVersionEntity other) {
        this.hostEntity = other.hostEntity;
        this.repositoryVersion = other.repositoryVersion;
        this.state = other.state;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getHostName() {
        return this.hostEntity != null ? this.hostEntity.getHostName() : null;
    }

    public HostEntity getHostEntity() {
        return this.hostEntity;
    }

    public void setHostEntity(HostEntity hostEntity) {
        this.hostEntity = hostEntity;
    }

    public RepositoryVersionState getState() {
        return this.state;
    }

    public void setState(RepositoryVersionState state) {
        this.state = state;
    }

    public RepositoryVersionEntity getRepositoryVersion() {
        return this.repositoryVersion;
    }

    public void setRepositoryVersion(RepositoryVersionEntity repositoryVersion) {
        this.repositoryVersion = repositoryVersion;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hostEntity == null ? 0 : this.hostEntity.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.repositoryVersion == null ? 0 : this.repositoryVersion.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostVersionEntity other = (HostVersionEntity)obj;
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        if (this.hostEntity != null ? !this.hostEntity.equals(other.hostEntity) : other.hostEntity != null) {
            return false;
        }
        if (this.repositoryVersion != null ? !this.repositoryVersion.equals(other.repositoryVersion) : other.repositoryVersion != null) {
            return false;
        }
        return this.state == other.state;
    }

    public Long getHostId() {
        return this.hostId;
    }

    public void setHostId(Long hostId) {
        this.hostId = hostId;
    }
}

