/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.state.HostState;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

@Table(name="hoststate")
@Entity
@NamedQueries(value={@NamedQuery(name="hostStateByHostId", query="SELECT hostState FROM HostStateEntity hostState WHERE hostState.hostId=:hostId")})
public class HostStateEntity {
    @Column(name="host_id", nullable=false, insertable=false, updatable=false)
    @Id
    private Long hostId;
    @Column(name="available_mem", nullable=false, insertable=true, updatable=true)
    @Basic
    private Long availableMem = 0L;
    @Column(name="time_in_state", nullable=false, insertable=true, updatable=true)
    @Basic
    private Long timeInState = 0L;
    @Column(name="health_status", insertable=true, updatable=true)
    @Basic
    private String healthStatus;
    @Column(name="agent_version", insertable=true, updatable=true)
    @Basic
    private String agentVersion = "";
    @Column(name="current_state", nullable=false, insertable=true, updatable=true)
    @Enumerated(value=EnumType.STRING)
    private HostState currentState = HostState.INIT;
    @Column(name="maintenance_state", nullable=true, insertable=true, updatable=true)
    private String maintenanceState = null;
    @OneToOne
    @JoinColumn(name="host_id", referencedColumnName="host_id", nullable=false)
    private HostEntity hostEntity;

    public Long getHostId() {
        return this.hostId;
    }

    public void setHostId(Long hostId) {
        this.hostId = hostId;
    }

    public Long getAvailableMem() {
        return this.availableMem;
    }

    public void setAvailableMem(Long availableMem) {
        this.availableMem = availableMem;
    }

    public Long getTimeInState() {
        return this.timeInState;
    }

    public void setTimeInState(Long timeInState) {
        this.timeInState = timeInState;
    }

    public String getHealthStatus() {
        return this.healthStatus;
    }

    public void setHealthStatus(String healthStatus) {
        this.healthStatus = healthStatus;
    }

    public String getAgentVersion() {
        return StringUtils.defaultString((String)this.agentVersion);
    }

    public void setAgentVersion(String agentVersion) {
        this.agentVersion = agentVersion;
    }

    public HostState getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(HostState currentState) {
        this.currentState = currentState;
    }

    public String getMaintenanceState() {
        return this.maintenanceState;
    }

    public void setMaintenanceState(String state) {
        this.maintenanceState = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostStateEntity that = (HostStateEntity)o;
        return Objects.equals(this.hostId, that.hostId) && Objects.equals(this.availableMem, that.availableMem) && Objects.equals(this.timeInState, that.timeInState) && Objects.equals(this.agentVersion, that.agentVersion) && this.currentState == that.currentState;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hostId, this.availableMem, this.timeInState, this.agentVersion, this.currentState});
    }

    public HostEntity getHostEntity() {
        return this.hostEntity;
    }

    public void setHostEntity(HostEntity hostEntity) {
        this.hostEntity = hostEntity;
    }
}

