/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.orm.entities.ExecutionCommandEntity;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.entities.StageEntity;
import id.onyx.obdp.server.orm.entities.TopologyLogicalTaskEntity;
import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

@Entity
@Table(name="host_role_command", indexes={@Index(name="idx_hrc_request_id", columnList="request_id"), @Index(name="idx_hrc_status_role", columnList="status, role")})
@TableGenerator(name="host_role_command_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="host_role_command_id_seq", initialValue=1)
@NamedQueries(value={@NamedQuery(name="HostRoleCommandEntity.findTaskIdsByRequestStageIds", query="SELECT command.taskId FROM HostRoleCommandEntity command WHERE command.stageId = :stageId AND command.requestId = :requestId"), @NamedQuery(name="HostRoleCommandEntity.findCountByCommandStatuses", query="SELECT COUNT(command.taskId) FROM HostRoleCommandEntity command WHERE command.status IN :statuses"), @NamedQuery(name="HostRoleCommandEntity.findByRequestIdAndStatuses", query="SELECT task FROM HostRoleCommandEntity task WHERE task.requestId=:requestId AND task.status IN :statuses ORDER BY task.taskId ASC"), @NamedQuery(name="HostRoleCommandEntity.findTasksByStatusesOrderByIdDesc", query="SELECT task FROM HostRoleCommandEntity task WHERE task.requestId = :requestId AND task.status IN :statuses ORDER BY task.taskId DESC"), @NamedQuery(name="HostRoleCommandEntity.findNumTasksAlreadyRanInStage", query="SELECT COUNT(task.taskId) FROM HostRoleCommandEntity task WHERE task.requestId = :requestId AND task.taskId > :taskId AND task.stageId > :stageId AND task.status NOT IN :statuses"), @NamedQuery(name="HostRoleCommandEntity.findByCommandStatuses", query="SELECT command FROM HostRoleCommandEntity command WHERE command.status IN :statuses ORDER BY command.requestId, command.stageId"), @NamedQuery(name="HostRoleCommandEntity.findByHostId", query="SELECT command FROM HostRoleCommandEntity command WHERE command.hostId=:hostId"), @NamedQuery(name="HostRoleCommandEntity.findByHostRole", query="SELECT command FROM HostRoleCommandEntity command WHERE command.hostEntity.hostName=:hostName AND command.requestId=:requestId AND command.stageId=:stageId AND command.role=:role ORDER BY command.taskId"), @NamedQuery(name="HostRoleCommandEntity.findByHostRoleNullHost", query="SELECT command FROM HostRoleCommandEntity command WHERE command.hostEntity IS NULL AND command.requestId=:requestId AND command.stageId=:stageId AND command.role=:role"), @NamedQuery(name="HostRoleCommandEntity.findByStatusBetweenStages", query="SELECT command FROM HostRoleCommandEntity command WHERE command.requestId = :requestId AND command.stageId >= :minStageId AND command.stageId <= :maxStageId AND command.status = :status"), @NamedQuery(name="HostRoleCommandEntity.updateAutoSkipExcludeRoleCommand", query="UPDATE HostRoleCommandEntity command SET command.autoSkipOnFailure = :autoSkipOnFailure WHERE command.requestId = :requestId AND command.roleCommand <> :roleCommand"), @NamedQuery(name="HostRoleCommandEntity.updateAutoSkipForRoleCommand", query="UPDATE HostRoleCommandEntity command SET command.autoSkipOnFailure = :autoSkipOnFailure WHERE command.requestId = :requestId AND command.roleCommand = :roleCommand"), @NamedQuery(name="HostRoleCommandEntity.removeByTaskIds", query="DELETE FROM HostRoleCommandEntity command WHERE command.taskId IN :taskIds"), @NamedQuery(name="HostRoleCommandEntity.findHostsByCommandStatus", query="SELECT DISTINCT(host.hostName) FROM HostRoleCommandEntity command, HostEntity host WHERE (command.requestId >= :iLowestRequestIdInProgress AND command.requestId <= :iHighestRequestIdInProgress) AND command.status IN :statuses AND command.hostId = host.hostId AND host.hostName IS NOT NULL"), @NamedQuery(name="HostRoleCommandEntity.getBlockingHostsForRequest", query="SELECT DISTINCT(host.hostName) FROM HostRoleCommandEntity command, HostEntity host WHERE command.requestId >= :lowerRequestIdInclusive AND command.requestId < :upperRequestIdExclusive AND command.status IN :statuses AND command.isBackgroundCommand=0 AND command.hostId = host.hostId AND host.hostName IS NOT NULL"), @NamedQuery(name="HostRoleCommandEntity.findLatestServiceChecksByRole", query="SELECT NEW id.onyx.obdp.server.orm.dao.HostRoleCommandDAO.LastServiceCheckDTO(command.role, MAX(command.endTime)) FROM HostRoleCommandEntity command WHERE command.roleCommand = :roleCommand AND command.endTime > 0 AND command.stage.clusterId = :clusterId GROUP BY command.role ORDER BY command.role ASC"), @NamedQuery(name="HostRoleCommandEntity.findByRequestId", query="SELECT command FROM HostRoleCommandEntity command WHERE command.requestId = :requestId ORDER BY command.taskId")})
public class HostRoleCommandEntity {
    private static int MAX_COMMAND_DETAIL_LENGTH = 250;
    @Column(name="task_id")
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="host_role_command_id_generator")
    private Long taskId;
    @Column(name="request_id", insertable=false, updatable=false, nullable=false)
    @Basic
    private Long requestId;
    @Column(name="stage_id", insertable=false, updatable=false, nullable=false)
    @Basic
    private Long stageId;
    @Column(name="host_id", insertable=false, updatable=false, nullable=true)
    @Basic
    private Long hostId;
    @Column(name="role")
    private String role;
    @Column(name="event", length=32000)
    @Basic
    @Lob
    private String event = "";
    @Column(name="exitcode", nullable=false)
    @Basic
    private Integer exitcode = 0;
    @Column(name="status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private HostRoleStatus status = HostRoleStatus.PENDING;
    @Column(name="std_error")
    @Lob
    @Basic
    private byte[] stdError = new byte[0];
    @Column(name="std_out")
    @Lob
    @Basic
    private byte[] stdOut = new byte[0];
    @Column(name="output_log")
    @Basic
    private String outputLog = null;
    @Column(name="error_log")
    @Basic
    private String errorLog = null;
    @Column(name="structured_out")
    @Lob
    @Basic
    private byte[] structuredOut = new byte[0];
    @Basic
    @Column(name="start_time", nullable=false)
    private Long startTime = -1L;
    @Basic
    @Column(name="original_start_time", nullable=false)
    private Long originalStartTime = -1L;
    @Basic
    @Column(name="end_time", nullable=false)
    private Long endTime = -1L;
    @Basic
    @Column(name="last_attempt_time", nullable=false)
    private Long lastAttemptTime = -1L;
    @Basic
    @Column(name="attempt_count", nullable=false)
    private Short attemptCount = 0;
    @Column(name="retry_allowed", nullable=false)
    private Integer retryAllowed = 0;
    @Column(name="auto_skip_on_failure", nullable=false)
    private Integer autoSkipOnFailure = 0;
    @Column(name="role_command")
    @Enumerated(value=EnumType.STRING)
    private RoleCommand roleCommand;
    @Column(name="command_detail")
    @Basic
    private String commandDetail;
    @Column(name="ops_display_name")
    @Basic
    private String opsDisplayName;
    @Column(name="custom_command_name")
    @Basic
    private String customCommandName;
    @OneToOne(mappedBy="hostRoleCommand", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private ExecutionCommandEntity executionCommand;
    @ManyToOne(cascade={CascadeType.MERGE})
    @JoinColumns(value={@JoinColumn(name="request_id", referencedColumnName="request_id", nullable=false), @JoinColumn(name="stage_id", referencedColumnName="stage_id", nullable=false)})
    private StageEntity stage;
    @ManyToOne(cascade={CascadeType.MERGE, CascadeType.REFRESH})
    @JoinColumn(name="host_id", referencedColumnName="host_id", nullable=true)
    private HostEntity hostEntity;
    @OneToOne(mappedBy="hostRoleCommandEntity", cascade={CascadeType.REMOVE})
    private TopologyLogicalTaskEntity topologyLogicalTaskEntity;
    @Basic
    @Column(name="is_background", nullable=false)
    private short isBackgroundCommand = 0;

    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public Long getRequestId() {
        return this.requestId;
    }

    public void setRequestId(Long requestId) {
        this.requestId = requestId;
    }

    public Long getStageId() {
        return this.stageId;
    }

    public void setStageId(Long stageId) {
        this.stageId = stageId;
    }

    public String getHostName() {
        return this.hostEntity != null ? this.hostEntity.getHostName() : null;
    }

    public Long getHostId() {
        return this.hostEntity != null ? this.hostEntity.getHostId() : null;
    }

    public Role getRole() {
        return Role.valueOf(this.role);
    }

    public void setRole(Role role) {
        this.role = role.name();
    }

    public String getEvent() {
        return StringUtils.defaultString((String)this.event);
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public Integer getExitcode() {
        return this.exitcode;
    }

    public void setExitcode(Integer exitcode) {
        this.exitcode = exitcode;
    }

    public HostRoleStatus getStatus() {
        return this.status;
    }

    public void setStatus(HostRoleStatus status) {
        this.status = status;
    }

    public byte[] getStdError() {
        return ArrayUtils.nullToEmpty((byte[])this.stdError);
    }

    public void setStdError(byte[] stdError) {
        this.stdError = stdError;
    }

    public byte[] getStdOut() {
        return ArrayUtils.nullToEmpty((byte[])this.stdOut);
    }

    public void setStdOut(byte[] stdOut) {
        this.stdOut = stdOut;
    }

    public String getOutputLog() {
        return this.outputLog;
    }

    public void setOutputLog(String outputLog) {
        this.outputLog = outputLog;
    }

    public String getErrorLog() {
        return this.errorLog;
    }

    public void setErrorLog(String errorLog) {
        this.errorLog = errorLog;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getOriginalStartTime() {
        return this.originalStartTime;
    }

    public void setOriginalStartTime(Long originalStartTime) {
        this.originalStartTime = originalStartTime;
    }

    public Long getLastAttemptTime() {
        return this.lastAttemptTime;
    }

    public void setLastAttemptTime(Long lastAttemptTime) {
        this.lastAttemptTime = lastAttemptTime;
    }

    public Short getAttemptCount() {
        return this.attemptCount;
    }

    public void setAttemptCount(Short attemptCount) {
        this.attemptCount = attemptCount;
    }

    public RoleCommand getRoleCommand() {
        return this.roleCommand;
    }

    public void setRoleCommand(RoleCommand roleCommand) {
        this.roleCommand = roleCommand;
    }

    public byte[] getStructuredOut() {
        return this.structuredOut;
    }

    public void setStructuredOut(byte[] structuredOut) {
        this.structuredOut = structuredOut;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public String getCommandDetail() {
        return this.commandDetail;
    }

    public void setCommandDetail(String commandDetail) {
        Object truncatedCommandDetail = commandDetail;
        if (commandDetail != null && commandDetail.length() > MAX_COMMAND_DETAIL_LENGTH) {
            truncatedCommandDetail = commandDetail.substring(0, MAX_COMMAND_DETAIL_LENGTH) + "...";
        }
        this.commandDetail = truncatedCommandDetail;
    }

    public String getCustomCommandName() {
        return this.customCommandName;
    }

    public void setCustomCommandName(String customCommandName) {
        this.customCommandName = customCommandName;
    }

    public String getOpsDisplayName() {
        return this.opsDisplayName;
    }

    public void setOpsDisplayName(String opsDisplayName) {
        this.opsDisplayName = opsDisplayName;
    }

    public boolean isRetryAllowed() {
        return this.retryAllowed != 0;
    }

    public void setRetryAllowed(boolean enabled) {
        this.retryAllowed = enabled ? 1 : 0;
    }

    public boolean isFailureAutoSkipped() {
        return this.autoSkipOnFailure != 0;
    }

    public void setAutoSkipOnFailure(boolean skipFailures) {
        this.autoSkipOnFailure = skipFailures ? 1 : 0;
    }

    public void setBackgroundCommand(boolean runInBackground) {
        this.isBackgroundCommand = (short)(runInBackground ? 1 : 0);
    }

    public boolean isBackgroundCommand() {
        return this.isBackgroundCommand != 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostRoleCommandEntity that = (HostRoleCommandEntity)o;
        if (this.attemptCount != null ? !this.attemptCount.equals(that.attemptCount) : that.attemptCount != null) {
            return false;
        }
        if (this.event != null ? !this.event.equals(that.event) : that.event != null) {
            return false;
        }
        if (this.exitcode != null ? !this.exitcode.equals(that.exitcode) : that.exitcode != null) {
            return false;
        }
        if (this.hostEntity != null ? !this.hostEntity.equals(that.hostEntity) : that.hostEntity != null) {
            return false;
        }
        if (this.lastAttemptTime != null ? !this.lastAttemptTime.equals(that.lastAttemptTime) : that.lastAttemptTime != null) {
            return false;
        }
        if (this.requestId != null ? !this.requestId.equals(that.requestId) : that.requestId != null) {
            return false;
        }
        if (this.role != null ? !this.role.equals(that.role) : that.role != null) {
            return false;
        }
        if (this.stageId != null ? !this.stageId.equals(that.stageId) : that.stageId != null) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) {
            return false;
        }
        if (this.originalStartTime != null ? !this.originalStartTime.equals(that.originalStartTime) : that.originalStartTime != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals((Object)that.status) : that.status != null) {
            return false;
        }
        if (this.stdError != null ? !Arrays.equals(this.stdError, that.stdError) : that.stdError != null) {
            return false;
        }
        if (this.stdOut != null ? !Arrays.equals(this.stdOut, that.stdOut) : that.stdOut != null) {
            return false;
        }
        if (this.outputLog != null ? !this.outputLog.equals(that.outputLog) : that.outputLog != null) {
            return false;
        }
        if (this.errorLog != null ? !this.errorLog.equals(that.errorLog) : that.errorLog != null) {
            return false;
        }
        if (this.taskId != null ? !this.taskId.equals(that.taskId) : that.taskId != null) {
            return false;
        }
        if (this.structuredOut != null ? !Arrays.equals(this.structuredOut, that.structuredOut) : that.structuredOut != null) {
            return false;
        }
        return !(this.endTime != null ? !this.endTime.equals(that.endTime) : that.endTime != null);
    }

    public int hashCode() {
        int result = this.taskId != null ? this.taskId.hashCode() : 0;
        result = 31 * result + (this.requestId != null ? this.requestId.hashCode() : 0);
        result = 31 * result + (this.stageId != null ? this.stageId.hashCode() : 0);
        result = 31 * result + (this.hostEntity != null ? this.hostEntity.hashCode() : 0);
        result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
        result = 31 * result + (this.event != null ? this.event.hashCode() : 0);
        result = 31 * result + (this.exitcode != null ? this.exitcode.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.stdError != null ? Arrays.hashCode(this.stdError) : 0);
        result = 31 * result + (this.stdOut != null ? Arrays.hashCode(this.stdOut) : 0);
        result = 31 * result + (this.outputLog != null ? this.outputLog.hashCode() : 0);
        result = 31 * result + (this.errorLog != null ? this.errorLog.hashCode() : 0);
        result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
        result = 31 * result + (this.originalStartTime != null ? this.originalStartTime.hashCode() : 0);
        result = 31 * result + (this.lastAttemptTime != null ? this.lastAttemptTime.hashCode() : 0);
        result = 31 * result + (this.attemptCount != null ? this.attemptCount.hashCode() : 0);
        result = 31 * result + (this.endTime != null ? this.endTime.hashCode() : 0);
        result = 31 * result + (this.structuredOut != null ? Arrays.hashCode(this.structuredOut) : 0);
        return result;
    }

    public ExecutionCommandEntity getExecutionCommand() {
        return this.executionCommand;
    }

    public void setExecutionCommand(ExecutionCommandEntity executionCommandsByTaskId) {
        this.executionCommand = executionCommandsByTaskId;
    }

    public StageEntity getStage() {
        return this.stage;
    }

    public void setStage(StageEntity stage) {
        this.stage = stage;
        if (null != stage) {
            if (null == this.stageId) {
                this.stageId = stage.getStageId();
            }
            if (null == this.requestId) {
                this.requestId = stage.getRequestId();
            }
        }
    }

    public HostEntity getHostEntity() {
        return this.hostEntity;
    }

    public void setHostEntity(HostEntity hostEntity) {
        this.hostEntity = hostEntity;
    }

    public TopologyLogicalTaskEntity getTopologyLogicalTaskEntity() {
        return this.topologyLogicalTaskEntity;
    }

    public void setTopologyLogicalTaskEntity(TopologyLogicalTaskEntity topologyLogicalTaskEntity) {
        this.topologyLogicalTaskEntity = topologyLogicalTaskEntity;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("HostRoleCommandEntity{ ");
        buffer.append("taskId").append(this.taskId);
        buffer.append(", stageId=").append(this.stageId);
        buffer.append(", requestId=").append(this.requestId);
        buffer.append(", role=").append(this.role);
        buffer.append(", roleCommand=").append((Object)this.roleCommand);
        buffer.append(", exitcode=").append(this.exitcode);
        buffer.append("}");
        return buffer.toString();
    }
}

