/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.BlueprintEntity;
import id.onyx.obdp.server.orm.entities.HostGroupComponentEntity;
import id.onyx.obdp.server.orm.entities.HostGroupConfigEntity;
import id.onyx.obdp.server.orm.entities.HostGroupEntityPK;
import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.Collection;

@IdClass(value=HostGroupEntityPK.class)
@Table(name="hostgroup")
@Entity
public class HostGroupEntity {
    @Id
    @Column(name="blueprint_name", nullable=false, insertable=false, updatable=false)
    private String blueprintName;
    @Id
    @Column(name="name", nullable=false, insertable=true, updatable=false)
    private String name;
    @Column
    @Basic
    private String cardinality = "NOT SPECIFIED";
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="hostGroup")
    private Collection<HostGroupComponentEntity> components;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="hostGroup")
    private Collection<HostGroupConfigEntity> configurations;
    @ManyToOne
    @JoinColumn(name="blueprint_name", referencedColumnName="blueprint_name", nullable=false)
    private BlueprintEntity blueprint;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BlueprintEntity getBlueprintEntity() {
        return this.blueprint;
    }

    public void setBlueprintEntity(BlueprintEntity entity) {
        this.blueprint = entity;
    }

    public String getBlueprintName() {
        return this.blueprintName;
    }

    public void setBlueprintName(String blueprintName) {
        this.blueprintName = blueprintName;
    }

    public Collection<HostGroupComponentEntity> getComponents() {
        return this.components;
    }

    public void setComponents(Collection<HostGroupComponentEntity> components) {
        this.components = components;
    }

    public void addComponent(HostGroupComponentEntity component) {
        this.components.add(component);
    }

    public Collection<HostGroupConfigEntity> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(Collection<HostGroupConfigEntity> configurations) {
        this.configurations = configurations;
    }

    public String getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(String cardinality) {
        if (cardinality != null) {
            this.cardinality = cardinality;
        }
    }
}

