/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.HostComponentDesiredStateEntity;
import id.onyx.obdp.server.orm.entities.HostComponentStateEntity;
import id.onyx.obdp.server.orm.entities.HostRoleCommandEntity;
import id.onyx.obdp.server.orm.entities.HostStateEntity;
import id.onyx.obdp.server.orm.entities.HostVersionEntity;
import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

@Entity
@Table(name="hosts")
@TableGenerator(name="host_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="host_id_seq", initialValue=0)
@NamedQueries(value={@NamedQuery(name="HostEntity.findByHostName", query="SELECT host FROM HostEntity host WHERE host.hostName = :hostName")})
public class HostEntity
implements Comparable<HostEntity> {
    @Id
    @Column(name="host_id", nullable=false, insertable=true, updatable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="host_id_generator")
    private Long hostId;
    @Column(name="host_name", nullable=false, insertable=true, updatable=true, unique=true)
    @Basic
    private String hostName;
    @Column(name="ipv4", nullable=true, insertable=true, updatable=true)
    @Basic
    private String ipv4;
    @Column(name="ipv6", nullable=true, insertable=true, updatable=true)
    @Basic
    private String ipv6;
    @Column(name="public_host_name", nullable=true, insertable=true, updatable=true)
    @Basic
    private String publicHostName;
    @Column(name="total_mem", nullable=false, insertable=true, updatable=true)
    @Basic
    private Long totalMem = 0L;
    @Column(name="cpu_count", nullable=false, insertable=true, updatable=true)
    @Basic
    private Integer cpuCount = 0;
    @Column(name="ph_cpu_count", nullable=false, insertable=true, updatable=true)
    @Basic
    private Integer phCpuCount = 0;
    @Column(name="cpu_info", insertable=true, updatable=true)
    @Basic
    private String cpuInfo = "";
    @Column(name="os_arch", insertable=true, updatable=true)
    @Basic
    private String osArch = "";
    @Column(name="os_info", insertable=true, updatable=true, length=1000)
    @Basic
    private String osInfo = "";
    @Column(name="os_type", insertable=true, updatable=true)
    @Basic
    private String osType = "";
    @Column(name="discovery_status", insertable=true, updatable=true, length=2000)
    @Basic
    private String discoveryStatus = "";
    @Column(name="last_registration_time", nullable=false, insertable=true, updatable=true)
    @Basic
    private Long lastRegistrationTime = 0L;
    @Column(name="rack_info", nullable=false, insertable=true, updatable=true)
    @Basic
    private String rackInfo = "/default-rack";
    @Column(name="host_attributes", insertable=true, updatable=true, length=20000)
    @Basic
    @Lob
    private String hostAttributes = "";
    @OneToMany(mappedBy="hostEntity")
    private Collection<HostComponentDesiredStateEntity> hostComponentDesiredStateEntities;
    @OneToMany(mappedBy="hostEntity")
    private Collection<HostComponentStateEntity> hostComponentStateEntities;
    @OneToMany(mappedBy="hostEntity", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private Collection<HostVersionEntity> hostVersionEntities;
    @ManyToMany
    @JoinTable(name="ClusterHostMapping", joinColumns={@JoinColumn(name="host_id", referencedColumnName="host_id")}, inverseJoinColumns={@JoinColumn(name="cluster_id", referencedColumnName="cluster_id")})
    private Collection<ClusterEntity> clusterEntities;
    @OneToOne(mappedBy="hostEntity", cascade={CascadeType.REMOVE, CascadeType.PERSIST})
    private HostStateEntity hostStateEntity;
    @OneToMany(mappedBy="hostEntity", cascade={CascadeType.REMOVE})
    private Collection<HostRoleCommandEntity> hostRoleCommandEntities;

    public Long getHostId() {
        return this.hostId;
    }

    public void setHostId(Long hostId) {
        this.hostId = hostId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getIpv4() {
        return this.ipv4;
    }

    public void setIpv4(String ipv4) {
        this.ipv4 = ipv4;
    }

    public String getIpv6() {
        return this.ipv6;
    }

    public void setIpv6(String ipv6) {
        this.ipv6 = ipv6;
    }

    public String getPublicHostName() {
        return this.publicHostName;
    }

    public void setPublicHostName(String name) {
        this.publicHostName = name;
    }

    public Long getTotalMem() {
        return this.totalMem;
    }

    public void setTotalMem(Long totalMem) {
        this.totalMem = totalMem;
    }

    public Integer getCpuCount() {
        return this.cpuCount;
    }

    public void setCpuCount(Integer cpuCount) {
        this.cpuCount = cpuCount;
    }

    public Integer getPhCpuCount() {
        return this.phCpuCount;
    }

    public void setPhCpuCount(Integer phCpuCount) {
        this.phCpuCount = phCpuCount;
    }

    public String getCpuInfo() {
        return StringUtils.defaultString((String)this.cpuInfo);
    }

    public void setCpuInfo(String cpuInfo) {
        this.cpuInfo = cpuInfo;
    }

    public String getOsArch() {
        return StringUtils.defaultString((String)this.osArch);
    }

    public void setOsArch(String osArch) {
        this.osArch = osArch;
    }

    public String getOsInfo() {
        return StringUtils.defaultString((String)this.osInfo);
    }

    public void setOsInfo(String osInfo) {
        this.osInfo = osInfo;
    }

    public String getOsType() {
        return StringUtils.defaultString((String)this.osType);
    }

    public void setOsType(String osType) {
        this.osType = osType;
    }

    public String getDiscoveryStatus() {
        return StringUtils.defaultString((String)this.discoveryStatus);
    }

    public void setDiscoveryStatus(String discoveryStatus) {
        this.discoveryStatus = discoveryStatus;
    }

    public Long getLastRegistrationTime() {
        return this.lastRegistrationTime;
    }

    public void setLastRegistrationTime(Long lastRegistrationTime) {
        this.lastRegistrationTime = lastRegistrationTime;
    }

    public String getRackInfo() {
        return this.rackInfo;
    }

    public void setRackInfo(String rackInfo) {
        this.rackInfo = rackInfo;
    }

    public String getHostAttributes() {
        return StringUtils.defaultString((String)this.hostAttributes);
    }

    public void setHostAttributes(String hostAttributes) {
        this.hostAttributes = hostAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostEntity that = (HostEntity)o;
        return Objects.equals(this.getHostId(), that.getHostId()) && Objects.equals(this.hostName, that.hostName);
    }

    public int hashCode() {
        return Objects.hash(this.getHostId(), this.hostName);
    }

    @Override
    public int compareTo(HostEntity other) {
        return this.hostName.compareTo(other.hostName);
    }

    public Collection<HostComponentDesiredStateEntity> getHostComponentDesiredStateEntities() {
        return Collections.unmodifiableCollection(this.hostComponentDesiredStateEntities);
    }

    public void addHostComponentDesiredStateEntity(HostComponentDesiredStateEntity stateEntity) {
        this.hostComponentDesiredStateEntities.add(stateEntity);
    }

    public void removeHostComponentDesiredStateEntity(HostComponentDesiredStateEntity stateEntity) {
        this.hostComponentDesiredStateEntities.remove(stateEntity);
    }

    public void setHostComponentDesiredStateEntities(Collection<HostComponentDesiredStateEntity> hostComponentDesiredStateEntities) {
        this.hostComponentDesiredStateEntities = hostComponentDesiredStateEntities;
    }

    public Collection<HostComponentStateEntity> getHostComponentStateEntities() {
        return Collections.unmodifiableCollection(this.hostComponentStateEntities);
    }

    public void addHostComponentStateEntity(HostComponentStateEntity stateEntity) {
        this.hostComponentStateEntities.add(stateEntity);
    }

    public void removeHostComponentStateEntity(HostComponentStateEntity stateEntity) {
        this.hostComponentStateEntities.remove(stateEntity);
    }

    public void setHostComponentStateEntities(Collection<HostComponentStateEntity> hostComponentStateEntities) {
        this.hostComponentStateEntities = hostComponentStateEntities;
    }

    public Collection<ClusterEntity> getClusterEntities() {
        return this.clusterEntities;
    }

    public void setClusterEntities(Collection<ClusterEntity> clusterEntities) {
        this.clusterEntities = clusterEntities;
    }

    public HostStateEntity getHostStateEntity() {
        return this.hostStateEntity;
    }

    public void setHostStateEntity(HostStateEntity hostStateEntity) {
        this.hostStateEntity = hostStateEntity;
    }

    public Collection<HostRoleCommandEntity> getHostRoleCommandEntities() {
        return this.hostRoleCommandEntities;
    }

    public void setHostRoleCommandEntities(Collection<HostRoleCommandEntity> hostRoleCommandEntities) {
        this.hostRoleCommandEntities = hostRoleCommandEntities;
    }

    public Collection<HostVersionEntity> getHostVersionEntities() {
        return this.hostVersionEntities;
    }

    public void setHostVersionEntities(Collection<HostVersionEntity> hostVersionEntities) {
        this.hostVersionEntities = hostVersionEntities;
    }
}

