/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import com.google.common.base.MoreObjects;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.entities.ServiceComponentDesiredStateEntity;
import id.onyx.obdp.server.state.State;
import id.onyx.obdp.server.state.UpgradeState;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;

@Entity
@Table(name="hostcomponentstate")
@TableGenerator(name="hostcomponentstate_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="hostcomponentstate_id_seq", initialValue=0)
@NamedQueries(value={@NamedQuery(name="HostComponentStateEntity.findAll", query="SELECT hcs from HostComponentStateEntity hcs"), @NamedQuery(name="HostComponentStateEntity.findByHost", query="SELECT hcs from HostComponentStateEntity hcs WHERE hcs.hostEntity.hostName=:hostName"), @NamedQuery(name="HostComponentStateEntity.findByService", query="SELECT hcs from HostComponentStateEntity hcs WHERE hcs.serviceName=:serviceName"), @NamedQuery(name="HostComponentStateEntity.findByServiceAndComponent", query="SELECT hcs from HostComponentStateEntity hcs WHERE hcs.serviceName=:serviceName AND hcs.componentName=:componentName"), @NamedQuery(name="HostComponentStateEntity.findByServiceComponentAndHost", query="SELECT hcs from HostComponentStateEntity hcs WHERE hcs.serviceName=:serviceName AND hcs.componentName=:componentName AND hcs.hostEntity.hostName=:hostName"), @NamedQuery(name="HostComponentStateEntity.findByIndex", query="SELECT hcs from HostComponentStateEntity hcs WHERE hcs.clusterId=:clusterId AND hcs.serviceName=:serviceName AND hcs.componentName=:componentName AND hcs.hostId=:hostId"), @NamedQuery(name="HostComponentStateEntity.findByServiceAndComponentAndNotVersion", query="SELECT hcs from HostComponentStateEntity hcs WHERE hcs.serviceName=:serviceName AND hcs.componentName=:componentName AND hcs.version != :version")})
public class HostComponentStateEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="hostcomponentstate_id_generator")
    @Column(name="id", nullable=false, insertable=true, updatable=false)
    private Long id;
    @Column(name="cluster_id", nullable=false, insertable=false, updatable=false, length=10)
    private Long clusterId;
    @Column(name="service_name", nullable=false, insertable=false, updatable=false)
    private String serviceName;
    @Column(name="host_id", nullable=false, insertable=false, updatable=false)
    private Long hostId;
    @Column(name="component_name", nullable=false, insertable=false, updatable=false)
    private String componentName;
    @Column(name="version", nullable=false, insertable=true, updatable=true)
    private String version = State.UNKNOWN.toString();
    @Enumerated(value=EnumType.STRING)
    @Column(name="current_state", nullable=false, insertable=true, updatable=true)
    private State currentState = State.INIT;
    @Enumerated(value=EnumType.STRING)
    @Column(name="upgrade_state", nullable=false, insertable=true, updatable=true)
    private UpgradeState upgradeState = UpgradeState.NONE;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="cluster_id", referencedColumnName="cluster_id", nullable=false), @JoinColumn(name="service_name", referencedColumnName="service_name", nullable=false), @JoinColumn(name="component_name", referencedColumnName="component_name", nullable=false)})
    private ServiceComponentDesiredStateEntity serviceComponentDesiredStateEntity;
    @ManyToOne
    @JoinColumn(name="host_id", referencedColumnName="host_id", nullable=false)
    private HostEntity hostEntity;

    public Long getId() {
        return this.id;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getHostName() {
        return this.hostEntity.getHostName();
    }

    public Long getHostId() {
        return this.hostEntity != null ? this.hostEntity.getHostId() : null;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public State getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(State currentState) {
        this.currentState = currentState;
    }

    public UpgradeState getUpgradeState() {
        return this.upgradeState;
    }

    public void setUpgradeState(UpgradeState upgradeState) {
        this.upgradeState = upgradeState;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostComponentStateEntity that = (HostComponentStateEntity)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.clusterId != null ? !this.clusterId.equals(that.clusterId) : that.clusterId != null) {
            return false;
        }
        if (this.componentName != null ? !this.componentName.equals(that.componentName) : that.componentName != null) {
            return false;
        }
        if (this.currentState != null ? !this.currentState.equals((Object)that.currentState) : that.currentState != null) {
            return false;
        }
        if (this.upgradeState != null ? !this.upgradeState.equals((Object)that.upgradeState) : that.upgradeState != null) {
            return false;
        }
        if (this.hostEntity != null ? !this.hostEntity.equals(that.hostEntity) : that.hostEntity != null) {
            return false;
        }
        if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.intValue() : 0;
        result = 31 * result + (this.clusterId != null ? this.clusterId.intValue() : 0);
        result = 31 * result + (this.hostEntity != null ? this.hostEntity.hashCode() : 0);
        result = 31 * result + (this.componentName != null ? this.componentName.hashCode() : 0);
        result = 31 * result + (this.currentState != null ? this.currentState.hashCode() : 0);
        result = 31 * result + (this.upgradeState != null ? this.upgradeState.hashCode() : 0);
        result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public ServiceComponentDesiredStateEntity getServiceComponentDesiredStateEntity() {
        return this.serviceComponentDesiredStateEntity;
    }

    public void setServiceComponentDesiredStateEntity(ServiceComponentDesiredStateEntity serviceComponentDesiredStateEntity) {
        this.serviceComponentDesiredStateEntity = serviceComponentDesiredStateEntity;
    }

    public HostEntity getHostEntity() {
        return this.hostEntity;
    }

    public void setHostEntity(HostEntity hostEntity) {
        this.hostEntity = hostEntity;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("serviceName", (Object)this.serviceName).add("componentName", (Object)this.componentName).add("hostId", (Object)this.hostId).add("state", (Object)this.currentState).toString();
    }
}

