/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.entities.ServiceComponentDesiredStateEntity;
import id.onyx.obdp.server.state.BlueprintProvisioningState;
import id.onyx.obdp.server.state.HostComponentAdminState;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.State;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import org.apache.commons.lang.StringUtils;

@Entity
@Table(name="hostcomponentdesiredstate", uniqueConstraints={@UniqueConstraint(name="UQ_hcdesiredstate_name", columnNames={"component_name", "service_name", "host_id", "cluster_id"})})
@TableGenerator(name="hostcomponentdesiredstate_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="hostcomponentdesiredstate_id_seq", initialValue=0)
@NamedQueries(value={@NamedQuery(name="HostComponentDesiredStateEntity.findAll", query="SELECT hcds from HostComponentDesiredStateEntity hcds"), @NamedQuery(name="HostComponentDesiredStateEntity.findByServiceAndComponent", query="SELECT hcds from HostComponentDesiredStateEntity hcds WHERE hcds.serviceName=:serviceName AND hcds.componentName=:componentName"), @NamedQuery(name="HostComponentDesiredStateEntity.findByServiceComponentAndHost", query="SELECT hcds from HostComponentDesiredStateEntity hcds WHERE hcds.serviceName=:serviceName AND hcds.componentName=:componentName AND hcds.hostEntity.hostName=:hostName"), @NamedQuery(name="HostComponentDesiredStateEntity.findByIndexAndHost", query="SELECT hcds from HostComponentDesiredStateEntity hcds WHERE hcds.clusterId=:clusterId AND hcds.serviceName=:serviceName AND hcds.componentName=:componentName AND hcds.hostId=:hostId"), @NamedQuery(name="HostComponentDesiredStateEntity.findByIndex", query="SELECT hcds from HostComponentDesiredStateEntity hcds WHERE hcds.clusterId=:clusterId AND hcds.serviceName=:serviceName AND hcds.componentName=:componentName"), @NamedQuery(name="HostComponentDesiredStateEntity.findByHostsAndCluster", query="SELECT hcds from HostComponentDesiredStateEntity hcds WHERE hcds.hostId IN :hostIds AND hcds.clusterId=:clusterId")})
public class HostComponentDesiredStateEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="hostcomponentdesiredstate_id_generator")
    @Column(name="id", nullable=false, insertable=true, updatable=false)
    private Long id;
    @Column(name="cluster_id", nullable=false, insertable=false, updatable=false, length=10)
    private Long clusterId;
    @Column(name="service_name", nullable=false, insertable=false, updatable=false)
    private String serviceName;
    @Column(name="host_id", nullable=false, insertable=false, updatable=false)
    private Long hostId;
    @Column(name="component_name", insertable=false, updatable=false)
    private String componentName = "";
    @Basic
    @Column(name="desired_state", nullable=false, insertable=true, updatable=true)
    @Enumerated(value=EnumType.STRING)
    private State desiredState = State.INIT;
    @Enumerated(value=EnumType.STRING)
    @Column(name="admin_state", nullable=true, insertable=true, updatable=true)
    private HostComponentAdminState adminState;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="cluster_id", referencedColumnName="cluster_id", nullable=false), @JoinColumn(name="service_name", referencedColumnName="service_name", nullable=false), @JoinColumn(name="component_name", referencedColumnName="component_name", nullable=false)})
    private ServiceComponentDesiredStateEntity serviceComponentDesiredStateEntity;
    @ManyToOne
    @JoinColumn(name="host_id", referencedColumnName="host_id", nullable=false)
    private HostEntity hostEntity;
    @Enumerated(value=EnumType.STRING)
    @Column(name="maintenance_state", nullable=false, insertable=true, updatable=true)
    private MaintenanceState maintenanceState = MaintenanceState.OFF;
    @Basic
    @Column(name="restart_required", insertable=true, updatable=true, nullable=false)
    private Integer restartRequired = 0;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="blueprint_provisioning_state", insertable=true, updatable=true)
    private BlueprintProvisioningState blueprintProvisioningState = BlueprintProvisioningState.NONE;

    public Long getId() {
        return this.id;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Long getHostId() {
        return this.hostEntity != null ? this.hostEntity.getHostId() : null;
    }

    public String getComponentName() {
        return StringUtils.defaultString((String)this.componentName);
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public State getDesiredState() {
        return this.desiredState;
    }

    public void setDesiredState(State desiredState) {
        this.desiredState = desiredState;
    }

    public HostComponentAdminState getAdminState() {
        return this.adminState;
    }

    public void setAdminState(HostComponentAdminState attribute) {
        this.adminState = attribute;
    }

    public MaintenanceState getMaintenanceState() {
        return this.maintenanceState;
    }

    public void setMaintenanceState(MaintenanceState state) {
        this.maintenanceState = state;
    }

    public void setHostId(Long hostId) {
        this.hostId = hostId;
    }

    public BlueprintProvisioningState getBlueprintProvisioningState() {
        return this.blueprintProvisioningState;
    }

    public void setBlueprintProvisioningState(BlueprintProvisioningState blueprintProvisioningState) {
        this.blueprintProvisioningState = blueprintProvisioningState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostComponentDesiredStateEntity that = (HostComponentDesiredStateEntity)o;
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.clusterId, (Object)that.clusterId)) {
            return false;
        }
        if (!Objects.equal((Object)this.componentName, (Object)that.componentName)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.desiredState), (Object)((Object)that.desiredState))) {
            return false;
        }
        if (!Objects.equal((Object)this.hostEntity, (Object)that.hostEntity)) {
            return false;
        }
        if (!Objects.equal((Object)this.serviceName, (Object)that.serviceName)) {
            return false;
        }
        return Objects.equal((Object)((Object)this.blueprintProvisioningState), (Object)((Object)that.blueprintProvisioningState));
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.clusterId != null ? this.clusterId.hashCode() : 0);
        result = 31 * result + (this.hostEntity != null ? this.hostEntity.hashCode() : 0);
        result = 31 * result + (this.componentName != null ? this.componentName.hashCode() : 0);
        result = 31 * result + (this.desiredState != null ? this.desiredState.hashCode() : 0);
        result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
        result = 31 * result + (this.blueprintProvisioningState != null ? this.blueprintProvisioningState.hashCode() : 0);
        return result;
    }

    public ServiceComponentDesiredStateEntity getServiceComponentDesiredStateEntity() {
        return this.serviceComponentDesiredStateEntity;
    }

    public void setServiceComponentDesiredStateEntity(ServiceComponentDesiredStateEntity serviceComponentDesiredStateEntity) {
        this.serviceComponentDesiredStateEntity = serviceComponentDesiredStateEntity;
    }

    public HostEntity getHostEntity() {
        return this.hostEntity;
    }

    public void setHostEntity(HostEntity hostEntity) {
        this.hostEntity = hostEntity;
    }

    public boolean isRestartRequired() {
        return this.restartRequired != 0;
    }

    public void setRestartRequired(boolean restartRequired) {
        this.restartRequired = !restartRequired ? 0 : 1;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("serviceName", (Object)this.serviceName).add("componentName", (Object)this.componentName).add("hostId", (Object)this.hostId).add("desiredState", (Object)this.desiredState).toString();
    }
}

