/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.MemberEntity;
import id.onyx.obdp.server.orm.entities.PrincipalEntity;
import id.onyx.obdp.server.security.authorization.GroupType;
import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.util.Set;

@Entity
@Table(name="\"groups\"", uniqueConstraints={@UniqueConstraint(columnNames={"group_name", "ldap_group"})})
@TableGenerator(name="group_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="group_id_seq", initialValue=1)
@NamedQueries(value={@NamedQuery(name="groupByName", query="SELECT group_entity FROM GroupEntity group_entity where lower(group_entity.groupName)=:groupname")})
public class GroupEntity {
    @Id
    @Column(name="group_id")
    @GeneratedValue(strategy=GenerationType.TABLE, generator="group_id_generator")
    private Integer groupId;
    @Column(name="group_name")
    private String groupName;
    @Column(name="ldap_group")
    private Integer ldapGroup = 0;
    @Column(name="group_type")
    @Enumerated(value=EnumType.STRING)
    @Basic
    private GroupType groupType = GroupType.LOCAL;
    @OneToMany(mappedBy="group", cascade={CascadeType.ALL})
    private Set<MemberEntity> memberEntities;
    @OneToOne
    @JoinColumns(value={@JoinColumn(name="principal_id", referencedColumnName="principal_id", nullable=false)})
    private PrincipalEntity principal;

    public Integer getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Integer groupId) {
        this.groupId = groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public Boolean getLdapGroup() {
        return this.ldapGroup == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    private void setLdapGroup(Boolean ldapGroup) {
        this.ldapGroup = ldapGroup == null ? null : Integer.valueOf(ldapGroup != false ? 1 : 0);
    }

    public GroupType getGroupType() {
        return this.groupType;
    }

    public void setGroupType(GroupType groupType) {
        this.groupType = groupType;
        this.setLdapGroup(groupType == GroupType.LDAP);
    }

    public Set<MemberEntity> getMemberEntities() {
        return this.memberEntities;
    }

    public void setMemberEntities(Set<MemberEntity> memberEntities) {
        this.memberEntities = memberEntities;
    }

    public PrincipalEntity getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(PrincipalEntity principal) {
        this.principal = principal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupEntity that = (GroupEntity)o;
        if (this.groupId != null ? !this.groupId.equals(that.groupId) : that.groupId != null) {
            return false;
        }
        if (this.groupName != null ? !this.groupName.equals(that.groupName) : that.groupName != null) {
            return false;
        }
        return !(this.ldapGroup != null ? !this.ldapGroup.equals(that.ldapGroup) : that.ldapGroup != null);
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.groupName != null ? this.groupName.hashCode() : 0);
        result = 31 * result + (this.ldapGroup != null ? this.ldapGroup.hashCode() : 0);
        return result;
    }
}

