/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.ExtensionEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;

@Table(name="extensionlink", uniqueConstraints={@UniqueConstraint(columnNames={"stack_id", "extension_id"})})
@TableGenerator(name="link_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="link_id_seq", initialValue=0)
@NamedQueries(value={@NamedQuery(name="ExtensionLinkEntity.findAll", query="SELECT link FROM ExtensionLinkEntity link"), @NamedQuery(name="ExtensionLinkEntity.findByStackAndExtensionName", query="SELECT link FROM ExtensionLinkEntity link WHERE link.stack.stackName = :stackName AND link.stack.stackVersion = :stackVersion AND link.extension.extensionName = :extensionName"), @NamedQuery(name="ExtensionLinkEntity.findByStackAndExtension", query="SELECT link FROM ExtensionLinkEntity link WHERE link.stack.stackName = :stackName AND link.stack.stackVersion = :stackVersion AND link.extension.extensionName = :extensionName AND link.extension.extensionVersion = :extensionVersion"), @NamedQuery(name="ExtensionLinkEntity.findByStack", query="SELECT link FROM ExtensionLinkEntity link WHERE link.stack.stackName = :stackName AND link.stack.stackVersion = :stackVersion"), @NamedQuery(name="ExtensionLinkEntity.findByExtension", query="SELECT link FROM ExtensionLinkEntity link WHERE link.extension.extensionName = :extensionName AND link.extension.extensionVersion = :extensionVersion")})
@Entity
public class ExtensionLinkEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="link_id_generator")
    @Column(name="link_id", nullable=false, updatable=false)
    private Long linkId;
    @OneToOne
    @JoinColumn(name="stack_id", unique=false, nullable=false, insertable=true, updatable=false)
    private StackEntity stack;
    @OneToOne
    @JoinColumn(name="extension_id", unique=false, nullable=false, insertable=true, updatable=false)
    private ExtensionEntity extension;

    public Long getLinkId() {
        return this.linkId;
    }

    public void setLinkId(Long linkId) {
        this.linkId = linkId;
    }

    public StackEntity getStack() {
        return this.stack;
    }

    public void setStack(StackEntity stack) {
        this.stack = stack;
    }

    public ExtensionEntity getExtension() {
        return this.extension;
    }

    public void setExtension(ExtensionEntity extension) {
        this.extension = extension;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ExtensionLinkEntity that = (ExtensionLinkEntity)object;
        return !(this.linkId != null ? !this.linkId.equals(that.linkId) : that.linkId != null);
    }

    public int hashCode() {
        int result = null != this.linkId ? this.linkId.hashCode() : 0;
        return result;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName());
        buffer.append("{");
        buffer.append("linkId=").append(this.linkId);
        buffer.append(", stackId=").append(this.stack.getStackId());
        buffer.append(", extensionId=").append(this.extension.getExtensionId());
        buffer.append("}");
        return buffer.toString();
    }
}

