/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.ConfigGroupConfigMappingEntity;
import id.onyx.obdp.server.orm.entities.ConfigGroupHostMappingEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.Collection;

@Table(name="configgroup")
@Entity
@NamedQueries(value={@NamedQuery(name="configGroupByName", query="SELECT configgroup FROM ConfigGroupEntity configgroup WHERE configgroup.groupName=:groupName"), @NamedQuery(name="allConfigGroups", query="SELECT configgroup FROM ConfigGroupEntity configgroup"), @NamedQuery(name="configGroupsByTag", query="SELECT configgroup FROM ConfigGroupEntity configgroup WHERE configgroup.tag=:tagName")})
@TableGenerator(name="configgroup_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="configgroup_id_seq", initialValue=1)
public class ConfigGroupEntity {
    @Id
    @Column(name="group_id", nullable=false, insertable=true, updatable=true)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="configgroup_id_generator")
    private Long groupId;
    @Column(name="cluster_id", insertable=false, updatable=false, nullable=false)
    private Long clusterId;
    @Column(name="group_name", nullable=false, unique=true, updatable=true)
    private String groupName;
    @Column(name="tag", nullable=false)
    private String tag;
    @Column(name="description")
    private String description;
    @Column(name="create_timestamp", nullable=false, insertable=true, updatable=false)
    private long timestamp;
    @Column(name="service_name")
    private String serviceName;
    @ManyToOne
    @JoinColumn(name="cluster_id", referencedColumnName="cluster_id", nullable=false)
    private ClusterEntity clusterEntity;
    @OneToMany(mappedBy="configGroupEntity", cascade={CascadeType.ALL})
    private Collection<ConfigGroupHostMappingEntity> configGroupHostMappingEntities;
    @OneToMany(mappedBy="configGroupEntity", cascade={CascadeType.ALL})
    private Collection<ConfigGroupConfigMappingEntity> configGroupConfigMappingEntities;

    public Long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public ClusterEntity getClusterEntity() {
        return this.clusterEntity;
    }

    public void setClusterEntity(ClusterEntity clusterEntity) {
        this.clusterEntity = clusterEntity;
    }

    public Collection<ConfigGroupHostMappingEntity> getConfigGroupHostMappingEntities() {
        return this.configGroupHostMappingEntities;
    }

    public void setConfigGroupHostMappingEntities(Collection<ConfigGroupHostMappingEntity> configGroupHostMappingEntities) {
        this.configGroupHostMappingEntities = configGroupHostMappingEntities;
    }

    public Collection<ConfigGroupConfigMappingEntity> getConfigGroupConfigMappingEntities() {
        return this.configGroupConfigMappingEntities;
    }

    public void setConfigGroupConfigMappingEntities(Collection<ConfigGroupConfigMappingEntity> configGroupConfigMappingEntities) {
        this.configGroupConfigMappingEntities = configGroupConfigMappingEntities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigGroupEntity that = (ConfigGroupEntity)o;
        if (!this.clusterId.equals(that.clusterId)) {
            return false;
        }
        if (!this.groupId.equals(that.groupId)) {
            return false;
        }
        if (!this.groupName.equals(that.groupName)) {
            return false;
        }
        return this.tag.equals(that.tag);
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.clusterId.hashCode();
        result = 31 * result + this.groupName.hashCode();
        result = 31 * result + this.tag.hashCode();
        return result;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}

