/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.ClusterServiceEntityPK;
import id.onyx.obdp.server.orm.entities.ServiceComponentDesiredStateEntity;
import id.onyx.obdp.server.orm.entities.ServiceDesiredStateEntity;
import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.util.Collection;

@IdClass(value=ClusterServiceEntityPK.class)
@Table(name="clusterservices")
@NamedQueries(value={@NamedQuery(name="clusterServiceByClusterAndServiceNames", query="SELECT clusterService FROM ClusterServiceEntity clusterService JOIN clusterService.clusterEntity cluster WHERE clusterService.serviceName=:serviceName AND cluster.clusterName=:clusterName")})
@Entity
public class ClusterServiceEntity {
    @Id
    @Column(name="cluster_id", nullable=false, insertable=false, updatable=false, length=10)
    private Long clusterId;
    @Id
    @Column(name="service_name", nullable=false, insertable=true, updatable=true)
    private String serviceName;
    @Basic
    @Column(name="service_enabled", nullable=false, insertable=true, updatable=true, length=10)
    private Integer serviceEnabled = 0;
    @ManyToOne
    @JoinColumn(name="cluster_id", referencedColumnName="cluster_id", nullable=false)
    private ClusterEntity clusterEntity;
    @OneToOne(mappedBy="clusterServiceEntity", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ServiceDesiredStateEntity serviceDesiredStateEntity;
    @OneToMany(mappedBy="clusterServiceEntity")
    private Collection<ServiceComponentDesiredStateEntity> serviceComponentDesiredStateEntities;

    public Long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public int getServiceEnabled() {
        return this.serviceEnabled;
    }

    public void setServiceEnabled(int serviceEnabled) {
        this.serviceEnabled = serviceEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterServiceEntity that = (ClusterServiceEntity)o;
        if (this.clusterId != null ? !this.clusterId.equals(that.clusterId) : that.clusterId != null) {
            return false;
        }
        if (this.serviceEnabled != null ? !this.serviceEnabled.equals(that.serviceEnabled) : that.serviceEnabled != null) {
            return false;
        }
        return !(this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null);
    }

    public int hashCode() {
        int result = this.clusterId != null ? this.clusterId.intValue() : 0;
        result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
        result = 31 * result + this.serviceEnabled;
        return result;
    }

    public ClusterEntity getClusterEntity() {
        return this.clusterEntity;
    }

    public void setClusterEntity(ClusterEntity clusterEntity) {
        this.clusterEntity = clusterEntity;
    }

    public ServiceDesiredStateEntity getServiceDesiredStateEntity() {
        return this.serviceDesiredStateEntity;
    }

    public void setServiceDesiredStateEntity(ServiceDesiredStateEntity serviceDesiredStateEntity) {
        this.serviceDesiredStateEntity = serviceDesiredStateEntity;
    }

    public Collection<ServiceComponentDesiredStateEntity> getServiceComponentDesiredStateEntities() {
        return this.serviceComponentDesiredStateEntities;
    }

    public void setServiceComponentDesiredStateEntities(Collection<ServiceComponentDesiredStateEntity> serviceComponentDesiredStateEntities) {
        this.serviceComponentDesiredStateEntities = serviceComponentDesiredStateEntities;
    }
}

