/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.orm.entities.ClusterConfigEntity;
import id.onyx.obdp.server.orm.entities.ClusterServiceEntity;
import id.onyx.obdp.server.orm.entities.ClusterStateEntity;
import id.onyx.obdp.server.orm.entities.ConfigGroupEntity;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.entities.RequestScheduleEntity;
import id.onyx.obdp.server.orm.entities.ResourceEntity;
import id.onyx.obdp.server.orm.entities.ServiceConfigEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.orm.entities.UpgradeEntity;
import id.onyx.obdp.server.orm.entities.WidgetEntity;
import id.onyx.obdp.server.orm.entities.WidgetLayoutEntity;
import id.onyx.obdp.server.state.SecurityType;
import id.onyx.obdp.server.state.State;
import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

@Table(name="clusters")
@NamedQueries(value={@NamedQuery(name="clusterByName", query="SELECT cluster FROM ClusterEntity cluster WHERE cluster.clusterName=:clusterName"), @NamedQuery(name="allClusters", query="SELECT clusters FROM ClusterEntity clusters"), @NamedQuery(name="clusterByResourceId", query="SELECT cluster FROM ClusterEntity cluster WHERE cluster.resource.id=:resourceId")})
@Entity
@TableGenerator(name="cluster_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="cluster_id_seq", initialValue=1)
public class ClusterEntity {
    @Id
    @Column(name="cluster_id", nullable=false, insertable=true, updatable=true)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="cluster_id_generator")
    private Long clusterId;
    @Basic
    @Column(name="cluster_name", nullable=false, insertable=true, updatable=true, unique=true, length=100)
    private String clusterName;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="provisioning_state", insertable=true, updatable=true)
    private State provisioningState = State.INIT;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="security_type", nullable=false, insertable=true, updatable=true)
    private SecurityType securityType = SecurityType.NONE;
    @Basic
    @Column(name="desired_cluster_state", insertable=true, updatable=true)
    private String desiredClusterState = "";
    @Basic
    @Column(name="cluster_info", insertable=true, updatable=true)
    private String clusterInfo = "";
    @OneToOne
    @JoinColumn(name="desired_stack_id", unique=false, nullable=false, insertable=true, updatable=true)
    private StackEntity desiredStack;
    @OneToMany(mappedBy="clusterEntity")
    private Collection<ClusterServiceEntity> clusterServiceEntities;
    @OneToOne(mappedBy="clusterEntity", cascade={CascadeType.REMOVE})
    private ClusterStateEntity clusterStateEntity;
    @ManyToMany(mappedBy="clusterEntities")
    private Collection<HostEntity> hostEntities;
    @OneToMany(mappedBy="clusterEntity")
    private Collection<ClusterConfigEntity> configEntities;
    @OneToMany(mappedBy="clusterEntity", cascade={CascadeType.ALL})
    private Collection<ConfigGroupEntity> configGroupEntities;
    @OneToMany(mappedBy="clusterEntity", cascade={CascadeType.ALL})
    private Collection<RequestScheduleEntity> requestScheduleEntities;
    @OneToMany(mappedBy="clusterEntity", cascade={CascadeType.REMOVE})
    private Collection<ServiceConfigEntity> serviceConfigEntities;
    @OneToMany(mappedBy="clusterEntity", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private Collection<AlertDefinitionEntity> alertDefinitionEntities;
    @OneToMany(mappedBy="clusterEntity", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private Collection<WidgetEntity> widgetEntities;
    @OneToMany(mappedBy="clusterEntity", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private Collection<WidgetLayoutEntity> widgetLayoutEntities;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumns(value={@JoinColumn(name="resource_id", referencedColumnName="resource_id", nullable=false)})
    private ResourceEntity resource;
    @Basic
    @Column(name="upgrade_id", nullable=true, insertable=false, updatable=false)
    private Long upgradeId;
    @OneToOne(cascade={CascadeType.REMOVE})
    @JoinColumn(name="upgrade_id", referencedColumnName="upgrade_id", nullable=true, insertable=false, updatable=true)
    private UpgradeEntity upgradeEntity = null;

    public Long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getDesiredClusterState() {
        return StringUtils.defaultString((String)this.desiredClusterState);
    }

    public void setDesiredClusterState(String desiredClusterState) {
        this.desiredClusterState = desiredClusterState;
    }

    public String getClusterInfo() {
        return StringUtils.defaultString((String)this.clusterInfo);
    }

    public void setClusterInfo(String clusterInfo) {
        this.clusterInfo = clusterInfo;
    }

    public StackEntity getDesiredStack() {
        return this.desiredStack;
    }

    public void setDesiredStack(StackEntity desiredStack) {
        this.desiredStack = desiredStack;
    }

    public State getProvisioningState() {
        return this.provisioningState;
    }

    public void setProvisioningState(State provisioningState) {
        this.provisioningState = provisioningState;
    }

    public SecurityType getSecurityType() {
        return this.securityType;
    }

    public void setSecurityType(SecurityType securityType) {
        this.securityType = securityType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterEntity that = (ClusterEntity)o;
        if (!this.clusterId.equals(that.clusterId)) {
            return false;
        }
        return this.clusterName.equals(that.clusterName);
    }

    public int hashCode() {
        int result = null == this.clusterId ? 0 : this.clusterId.hashCode();
        result = 31 * result + this.clusterName.hashCode();
        return result;
    }

    public Collection<ClusterServiceEntity> getClusterServiceEntities() {
        return this.clusterServiceEntities;
    }

    public void setClusterServiceEntities(Collection<ClusterServiceEntity> clusterServiceEntities) {
        this.clusterServiceEntities = clusterServiceEntities;
    }

    public ClusterStateEntity getClusterStateEntity() {
        return this.clusterStateEntity;
    }

    public void setClusterStateEntity(ClusterStateEntity clusterStateEntity) {
        this.clusterStateEntity = clusterStateEntity;
    }

    public Collection<HostEntity> getHostEntities() {
        return this.hostEntities;
    }

    public void setHostEntities(Collection<HostEntity> hostEntities) {
        this.hostEntities = hostEntities;
    }

    public Collection<ClusterConfigEntity> getClusterConfigEntities() {
        return this.configEntities;
    }

    public void setClusterConfigEntities(Collection<ClusterConfigEntity> entities) {
        this.configEntities = entities;
    }

    public Collection<ConfigGroupEntity> getConfigGroupEntities() {
        return this.configGroupEntities;
    }

    public void setConfigGroupEntities(Collection<ConfigGroupEntity> configGroupEntities) {
        this.configGroupEntities = configGroupEntities;
    }

    public Collection<RequestScheduleEntity> getRequestScheduleEntities() {
        return this.requestScheduleEntities;
    }

    public void setRequestScheduleEntities(Collection<RequestScheduleEntity> requestScheduleEntities) {
        this.requestScheduleEntities = requestScheduleEntities;
    }

    public Collection<ServiceConfigEntity> getServiceConfigEntities() {
        return this.serviceConfigEntities;
    }

    public void setServiceConfigEntities(Collection<ServiceConfigEntity> serviceConfigEntities) {
        this.serviceConfigEntities = serviceConfigEntities;
    }

    public Collection<AlertDefinitionEntity> getAlertDefinitionEntities() {
        return this.alertDefinitionEntities;
    }

    public ResourceEntity getResource() {
        return this.resource;
    }

    public void setResource(ResourceEntity resource) {
        this.resource = resource;
    }

    public UpgradeEntity getUpgradeEntity() {
        return this.upgradeEntity;
    }

    public void setUpgradeEntity(UpgradeEntity upgradeEntity) {
        this.upgradeEntity = upgradeEntity;
    }
}

