/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import com.google.common.base.MoreObjects;
import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.ConfigGroupConfigMappingEntity;
import id.onyx.obdp.server.orm.entities.ServiceConfigEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang.builder.EqualsBuilder;

@Entity
@Table(name="clusterconfig", uniqueConstraints={@UniqueConstraint(name="UQ_config_type_tag", columnNames={"cluster_id", "type_name", "version_tag"}), @UniqueConstraint(name="UQ_config_type_version", columnNames={"cluster_id", "type_name", "version"})})
@TableGenerator(name="config_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="config_id_seq", initialValue=1)
@NamedQueries(value={@NamedQuery(name="ClusterConfigEntity.findNextConfigVersion", query="SELECT COALESCE(MAX(clusterConfig.version),0) + 1 as nextVersion FROM ClusterConfigEntity clusterConfig WHERE clusterConfig.type=:configType AND clusterConfig.clusterId=:clusterId"), @NamedQuery(name="ClusterConfigEntity.findAllConfigsByStack", query="SELECT clusterConfig FROM ClusterConfigEntity clusterConfig WHERE clusterConfig.clusterId=:clusterId AND clusterConfig.stack=:stack"), @NamedQuery(name="ClusterConfigEntity.findLatestConfigsByStack", query="SELECT clusterConfig FROM ClusterConfigEntity clusterConfig WHERE clusterConfig.clusterId = :clusterId AND clusterConfig.stack = :stack AND clusterConfig.selectedTimestamp = (SELECT MAX(clusterConfig2.selectedTimestamp) FROM ClusterConfigEntity clusterConfig2 WHERE clusterConfig2.clusterId=:clusterId AND clusterConfig2.stack=:stack AND clusterConfig2.type = clusterConfig.type)"), @NamedQuery(name="ClusterConfigEntity.findLatestConfigsByStackWithTypes", query="SELECT clusterConfig FROM ClusterConfigEntity clusterConfig WHERE clusterConfig.type IN :types AND clusterConfig.clusterId = :clusterId AND clusterConfig.stack = :stack AND clusterConfig.selectedTimestamp = (SELECT MAX(clusterConfig2.selectedTimestamp) FROM ClusterConfigEntity clusterConfig2 WHERE clusterConfig2.clusterId=:clusterId AND clusterConfig2.stack=:stack AND clusterConfig2.type = clusterConfig.type)"), @NamedQuery(name="ClusterConfigEntity.findNotMappedClusterConfigsToService", query="SELECT clusterConfig FROM ClusterConfigEntity clusterConfig WHERE clusterConfig.serviceConfigEntities IS EMPTY AND clusterConfig.type != 'cluster-env'"), @NamedQuery(name="ClusterConfigEntity.findEnabledConfigsByStack", query="SELECT config FROM ClusterConfigEntity config WHERE config.clusterId = :clusterId AND config.selected = 1 AND config.stack = :stack"), @NamedQuery(name="ClusterConfigEntity.findEnabledConfigByType", query="SELECT config FROM ClusterConfigEntity config WHERE config.clusterId = :clusterId AND config.selected = 1 and config.type = :type"), @NamedQuery(name="ClusterConfigEntity.findEnabledConfigsByTypes", query="SELECT config FROM ClusterConfigEntity config WHERE config.clusterId = :clusterId AND config.selected = 1 and config.type in :types"), @NamedQuery(name="ClusterConfigEntity.findEnabledConfigs", query="SELECT config FROM ClusterConfigEntity config WHERE config.clusterId = :clusterId AND config.selected = 1")})
public class ClusterConfigEntity {
    @Id
    @Column(name="config_id")
    @GeneratedValue(strategy=GenerationType.TABLE, generator="config_id_generator")
    private Long configId;
    @Column(name="cluster_id", nullable=false, insertable=false, updatable=false, length=10)
    private Long clusterId;
    @Column(name="type_name")
    private String type;
    @Column(name="version")
    private Long version;
    @Column(name="version_tag")
    private String tag;
    @Column(name="selected", insertable=true, updatable=true, nullable=false)
    private int selected = 0;
    @Basic(fetch=FetchType.LAZY)
    @Column(name="config_data", nullable=false, insertable=true)
    @Lob
    private String configJson;
    @Basic(fetch=FetchType.LAZY)
    @Column(name="config_attributes", nullable=true, insertable=true)
    @Lob
    private String configAttributesJson;
    @Column(name="create_timestamp", nullable=false, insertable=true, updatable=false)
    private long timestamp;
    @Column(name="selected_timestamp", nullable=false, insertable=true, updatable=true)
    private long selectedTimestamp = 0L;
    @ManyToOne
    @JoinColumn(name="cluster_id", referencedColumnName="cluster_id", nullable=false)
    private ClusterEntity clusterEntity;
    @OneToMany(mappedBy="clusterConfigEntity")
    private Collection<ConfigGroupConfigMappingEntity> configGroupConfigMappingEntities;
    @ManyToMany(mappedBy="clusterConfigEntities")
    private Collection<ServiceConfigEntity> serviceConfigEntities;
    @Column(name="unmapped", nullable=false, insertable=true, updatable=true)
    private short unmapped = 0;
    @OneToOne
    @JoinColumn(name="stack_id", unique=false, nullable=false, insertable=true, updatable=true)
    private StackEntity stack;

    public boolean isUnmapped() {
        return this.unmapped != 0;
    }

    public void setUnmapped(boolean unmapped) {
        this.unmapped = (short)(unmapped ? 1 : 0);
    }

    public Long getConfigId() {
        return this.configId;
    }

    public void setConfigId(Long configId) {
        this.configId = configId;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String typeName) {
        this.type = typeName;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String versionTag) {
        this.tag = versionTag;
    }

    public String getData() {
        return this.configJson;
    }

    public void setData(String data) {
        this.configJson = data;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long stamp) {
        this.timestamp = stamp;
    }

    public long getSelectedTimestamp() {
        return this.selectedTimestamp;
    }

    public String getAttributes() {
        return this.configAttributesJson;
    }

    public void setAttributes(String attributes) {
        this.configAttributesJson = attributes;
    }

    public StackEntity getStack() {
        return this.stack;
    }

    public void setStack(StackEntity stack) {
        this.stack = stack;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ClusterConfigEntity that = (ClusterConfigEntity)object;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)this.configId, (Object)that.configId);
        equalsBuilder.append((Object)this.clusterId, (Object)that.clusterId);
        equalsBuilder.append((Object)this.type, (Object)that.type);
        equalsBuilder.append((Object)this.tag, (Object)that.tag);
        equalsBuilder.append((Object)this.stack, (Object)that.stack);
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        return Objects.hash(this.configId, this.clusterId, this.type, this.tag, this.stack);
    }

    public ClusterEntity getClusterEntity() {
        return this.clusterEntity;
    }

    public void setClusterEntity(ClusterEntity clusterEntity) {
        this.clusterEntity = clusterEntity;
    }

    public Collection<ConfigGroupConfigMappingEntity> getConfigGroupConfigMappingEntities() {
        return this.configGroupConfigMappingEntities;
    }

    public void setConfigGroupConfigMappingEntities(Collection<ConfigGroupConfigMappingEntity> configGroupConfigMappingEntities) {
        this.configGroupConfigMappingEntities = configGroupConfigMappingEntities;
    }

    public Collection<ServiceConfigEntity> getServiceConfigEntities() {
        return this.serviceConfigEntities;
    }

    public void setServiceConfigEntities(Collection<ServiceConfigEntity> serviceConfigEntities) {
        this.serviceConfigEntities = serviceConfigEntities;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clusterId", (Object)this.clusterId).add("type", (Object)this.type).add("version", (Object)this.version).add("tag", (Object)this.tag).add("selected", this.selected == 1).add("selectedTimeStamp", this.selectedTimestamp).add("created", this.timestamp).toString();
    }

    public boolean isSelected() {
        return this.selected == 1;
    }

    public void setSelected(boolean selected) {
        int n = this.selected = selected ? 1 : 0;
        if (selected) {
            this.selectedTimestamp = System.currentTimeMillis();
        }
    }
}

