/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.BlueprintConfigEntity;
import id.onyx.obdp.server.orm.entities.BlueprintSettingEntity;
import id.onyx.obdp.server.orm.entities.HostGroupEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.state.SecurityType;
import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.util.Collection;

@Table(name="blueprint")
@NamedQuery(name="allBlueprints", query="SELECT blueprint FROM BlueprintEntity blueprint")
@Entity
public class BlueprintEntity {
    @Id
    @Column(name="blueprint_name", nullable=false, insertable=true, updatable=false, unique=true, length=100)
    private String blueprintName;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="security_type", nullable=false, insertable=true, updatable=true)
    private SecurityType securityType = SecurityType.NONE;
    @Basic
    @Column(name="security_descriptor_reference", nullable=true, insertable=true, updatable=true)
    private String securityDescriptorReference;
    @OneToOne
    @JoinColumn(name="stack_id", unique=false, nullable=false, insertable=true, updatable=false)
    private StackEntity stack;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="blueprint")
    private Collection<HostGroupEntity> hostGroups;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="blueprint")
    private Collection<BlueprintConfigEntity> configurations;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="blueprint")
    private Collection<BlueprintSettingEntity> settings;

    public String getBlueprintName() {
        return this.blueprintName;
    }

    public void setBlueprintName(String blueprintName) {
        this.blueprintName = blueprintName;
    }

    public StackEntity getStack() {
        return this.stack;
    }

    public void setStack(StackEntity stack) {
        this.stack = stack;
    }

    public Collection<HostGroupEntity> getHostGroups() {
        return this.hostGroups;
    }

    public void setHostGroups(Collection<HostGroupEntity> hostGroups) {
        this.hostGroups = hostGroups;
    }

    public Collection<BlueprintConfigEntity> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(Collection<BlueprintConfigEntity> configurations) {
        this.configurations = configurations;
    }

    public Collection<BlueprintSettingEntity> getSettings() {
        return this.settings;
    }

    public void setSettings(Collection<BlueprintSettingEntity> settings) {
        this.settings = settings;
    }

    public SecurityType getSecurityType() {
        return this.securityType;
    }

    public void setSecurityType(SecurityType securityType) {
        this.securityType = securityType;
    }

    public String getSecurityDescriptorReference() {
        return this.securityDescriptorReference;
    }

    public void setSecurityDescriptorReference(String securityDescriptorReference) {
        this.securityDescriptorReference = securityDescriptorReference;
    }
}

