/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import com.google.gson.Gson;
import id.onyx.obdp.server.orm.entities.ArtifactEntityPK;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.QueryHint;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.Collections;
import java.util.Map;

@IdClass(value=ArtifactEntityPK.class)
@Table(name="artifact")
@NamedQueries(value={@NamedQuery(name="artifactByNameAndForeignKeys", query="SELECT artifact FROM ArtifactEntity artifact WHERE artifact.artifactName=:artifactName AND artifact.foreignKeys=:foreignKeys", hints={@QueryHint(name="eclipselink.query-results-cache", value="True"), @QueryHint(name="eclipselink.query-results-cache.size", value="100")}), @NamedQuery(name="artifactByName", query="SELECT artifact FROM ArtifactEntity artifact WHERE artifact.artifactName=:artifactName"), @NamedQuery(name="artifactByForeignKeys", query="SELECT artifact FROM ArtifactEntity artifact WHERE artifact.foreignKeys=:foreignKeys")})
@Entity
public class ArtifactEntity {
    @Id
    @Column(name="artifact_name", nullable=false, insertable=true, updatable=false, unique=true)
    private String artifactName;
    @Id
    @Column(name="foreign_keys", nullable=false, insertable=true, updatable=false)
    @Basic
    private String foreignKeys;
    @Column(name="artifact_data", nullable=false, insertable=true, updatable=true)
    @Basic
    private String artifactData;
    @Transient
    private static final Gson jsonSerializer = new Gson();

    public String getArtifactName() {
        return this.artifactName;
    }

    public void setArtifactName(String artifactName) {
        this.artifactName = artifactName;
    }

    public void setArtifactData(Map<String, Object> artifactData) {
        this.artifactData = jsonSerializer.toJson(artifactData);
    }

    public Map<String, Object> getArtifactData() {
        return (Map)jsonSerializer.fromJson(this.artifactData, Map.class);
    }

    public void setForeignKeys(Map<String, String> foreignKeys) {
        this.foreignKeys = ArtifactEntity.serializeForeignKeys(foreignKeys);
    }

    public Map<String, String> getForeignKeys() {
        return this.foreignKeys == null ? Collections.emptyMap() : (Map)jsonSerializer.fromJson(this.foreignKeys, Map.class);
    }

    public static String serializeForeignKeys(Map<String, String> foreignKeys) {
        return jsonSerializer.toJson(foreignKeys);
    }
}

