/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import com.google.common.collect.ImmutableSet;
import id.onyx.obdp.server.orm.entities.AlertGroupEntity;
import id.onyx.obdp.server.orm.entities.AlertNoticeEntity;
import id.onyx.obdp.server.state.AlertState;
import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PreRemove;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@Entity
@Table(name="alert_target")
@TableGenerator(name="alert_target_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="alert_target_id_seq", initialValue=0)
@NamedQueries(value={@NamedQuery(name="AlertTargetEntity.findAll", query="SELECT alertTarget FROM AlertTargetEntity alertTarget"), @NamedQuery(name="AlertTargetEntity.findAllGlobal", query="SELECT alertTarget FROM AlertTargetEntity alertTarget WHERE alertTarget.isGlobal = 1"), @NamedQuery(name="AlertTargetEntity.findByName", query="SELECT alertTarget FROM AlertTargetEntity alertTarget WHERE alertTarget.targetName = :targetName"), @NamedQuery(name="AlertTargetEntity.findByIds", query="SELECT alertTarget FROM AlertTargetEntity alertTarget WHERE alertTarget.targetId IN :targetIds")})
public class AlertTargetEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="alert_target_id_generator")
    @Column(name="target_id", nullable=false, updatable=false)
    private Long targetId;
    @Column(length=1024)
    private String description;
    @Column(name="notification_type", nullable=false, length=64)
    private String notificationType;
    @Lob
    @Basic
    @Column(length=32672)
    private String properties;
    @Column(name="target_name", unique=true, nullable=false, length=255)
    private String targetName;
    @Column(name="is_global", nullable=false, length=1)
    private Short isGlobal = 0;
    @Column(name="is_enabled", nullable=false, length=1)
    private Short isEnabled = 1;
    @ManyToMany(fetch=FetchType.EAGER, mappedBy="alertTargets", cascade={CascadeType.MERGE, CascadeType.REFRESH})
    private Set<AlertGroupEntity> alertGroups;
    @Enumerated(value=EnumType.STRING)
    @ElementCollection(targetClass=AlertState.class)
    @CollectionTable(name="alert_target_states", joinColumns={@JoinColumn(name="target_id")})
    @Column(name="alert_state")
    private Set<AlertState> alertStates = EnumSet.allOf(AlertState.class);
    @OneToMany(cascade={CascadeType.REMOVE}, mappedBy="alertTarget")
    private List<AlertNoticeEntity> alertNotices;

    public Long getTargetId() {
        return this.targetId;
    }

    public void setTargetId(Long targetId) {
        this.targetId = targetId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getNotificationType() {
        return this.notificationType;
    }

    public void setNotificationType(String notificationType) {
        this.notificationType = notificationType;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public boolean isGlobal() {
        return this.isGlobal != 0;
    }

    public void setGlobal(boolean isGlobal) {
        this.isGlobal = isGlobal ? (short)1 : 0;
    }

    public boolean isEnabled() {
        return this.isEnabled != 0;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled ? (short)1 : 0;
    }

    public Set<AlertState> getAlertStates() {
        return this.alertStates;
    }

    public void setAlertStates(Set<AlertState> alertStates) {
        this.alertStates = alertStates;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public Set<AlertGroupEntity> getAlertGroups() {
        if (null == this.alertGroups) {
            return Collections.emptySet();
        }
        return ImmutableSet.copyOf(this.alertGroups);
    }

    public void setAlertGroups(Set<AlertGroupEntity> alertGroups) {
        Set<AlertGroupEntity> groups = this.getAlertGroups();
        for (AlertGroupEntity group : groups) {
            group.removeAlertTarget(this);
        }
        this.alertGroups = alertGroups;
        if (null != alertGroups) {
            for (AlertGroupEntity group : alertGroups) {
                group.addAlertTarget(this);
            }
        }
    }

    protected void addAlertGroup(AlertGroupEntity alertGroup) {
        if (null == this.alertGroups) {
            this.alertGroups = new HashSet<AlertGroupEntity>();
        }
        this.alertGroups.add(alertGroup);
    }

    protected void removeAlertGroup(AlertGroupEntity alertGroup) {
        if (null != this.alertGroups) {
            this.alertGroups.remove(alertGroup);
        }
    }

    protected void addAlertNotice(AlertNoticeEntity notice) {
        if (null == this.alertNotices) {
            this.alertNotices = new ArrayList<AlertNoticeEntity>();
        }
        this.alertNotices.add(notice);
    }

    public List<AlertNoticeEntity> getAlertNotices() {
        return this.alertNotices;
    }

    public void setAlertNotices(List<AlertNoticeEntity> alertNotices) {
        this.alertNotices = alertNotices;
    }

    @PreRemove
    public void preRemove() {
        Set<AlertGroupEntity> groups = this.getAlertGroups();
        if (!groups.isEmpty()) {
            for (AlertGroupEntity group : groups) {
                group.removeAlertTarget(this);
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AlertTargetEntity that = (AlertTargetEntity)object;
        if (null != this.targetId) {
            return Objects.equals(this.targetId, that.targetId);
        }
        return Objects.equals(this.targetId, that.targetId) && Objects.equals(this.targetName, that.targetName) && Objects.equals(this.notificationType, that.notificationType) && Objects.equals(this.isEnabled, that.isEnabled) && Objects.equals(this.description, that.description) && Objects.equals(this.isGlobal, that.isGlobal);
    }

    public int hashCode() {
        if (null != this.targetId) {
            return this.targetId.hashCode();
        }
        return Objects.hash(this.targetId, this.targetName, this.notificationType, this.isEnabled, this.description, this.isGlobal);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName());
        buffer.append("{");
        buffer.append("id=").append(this.targetId);
        buffer.append(", name=").append(this.targetName);
        buffer.append("}");
        return buffer.toString();
    }
}

