/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.AlertHistoryEntity;
import id.onyx.obdp.server.orm.entities.AlertTargetEntity;
import id.onyx.obdp.server.state.NotificationState;
import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import org.apache.commons.lang.builder.EqualsBuilder;

@Entity
@Table(name="alert_notice")
@TableGenerator(name="alert_notice_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="alert_notice_id_seq", initialValue=0)
@NamedQueries(value={@NamedQuery(name="AlertNoticeEntity.findAll", query="SELECT notice FROM AlertNoticeEntity notice"), @NamedQuery(name="AlertNoticeEntity.findByState", query="SELECT notice FROM AlertNoticeEntity notice WHERE notice.notifyState = :notifyState  ORDER BY  notice.notificationId"), @NamedQuery(name="AlertNoticeEntity.findByUuid", query="SELECT notice FROM AlertNoticeEntity notice WHERE notice.uuid = :uuid"), @NamedQuery(name="AlertNoticeEntity.findByHistoryIds", query="SELECT notice FROM AlertNoticeEntity notice WHERE notice.historyId IN :historyIds"), @NamedQuery(name="AlertNoticeEntity.removeByHistoryIds", query="DELETE FROM AlertNoticeEntity notice WHERE notice.historyId IN :historyIds")})
public class AlertNoticeEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="alert_notice_id_generator")
    @Column(name="notification_id", nullable=false, updatable=false)
    private Long notificationId;
    @Enumerated(value=EnumType.STRING)
    @Column(name="notify_state", nullable=false, length=255)
    private NotificationState notifyState;
    @Basic
    @Column(nullable=false, length=64, unique=true)
    private String uuid;
    @ManyToOne
    @JoinColumn(name="history_id", nullable=false)
    private AlertHistoryEntity alertHistory;
    @Column(name="history_id", nullable=false, insertable=false, updatable=false, length=10)
    private Long historyId;
    @ManyToOne(cascade={CascadeType.MERGE, CascadeType.REFRESH})
    @JoinColumn(name="target_id", nullable=false)
    private AlertTargetEntity alertTarget;

    public Long getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(Long notificationId) {
        this.notificationId = notificationId;
    }

    public NotificationState getNotifyState() {
        return this.notifyState;
    }

    public void setNotifyState(NotificationState notifyState) {
        this.notifyState = notifyState;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public AlertHistoryEntity getAlertHistory() {
        return this.alertHistory;
    }

    public void setAlertHistory(AlertHistoryEntity alertHistory) {
        this.alertHistory = alertHistory;
        this.historyId = alertHistory.getAlertId();
    }

    public Long getHistoryId() {
        return this.historyId;
    }

    public void setHistoryId(Long historyId) {
        this.historyId = historyId;
    }

    public AlertTargetEntity getAlertTarget() {
        return this.alertTarget;
    }

    public void setAlertTarget(AlertTargetEntity alertTarget) {
        this.alertTarget = alertTarget;
        alertTarget.addAlertNotice(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AlertNoticeEntity that = (AlertNoticeEntity)object;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)this.uuid, (Object)that.uuid);
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        int result = null != this.uuid ? this.uuid.hashCode() : 0;
        return result;
    }
}

