/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.state.AlertState;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.Objects;

@Entity
@Table(name="alert_history")
@TableGenerator(name="alert_history_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="alert_history_id_seq", initialValue=0)
@NamedQueries(value={@NamedQuery(name="AlertHistoryEntity.findAll", query="SELECT alertHistory FROM AlertHistoryEntity alertHistory"), @NamedQuery(name="AlertHistoryEntity.findAllInCluster", query="SELECT alertHistory FROM AlertHistoryEntity alertHistory WHERE alertHistory.clusterId = :clusterId"), @NamedQuery(name="AlertHistoryEntity.findAllInClusterWithState", query="SELECT alertHistory FROM AlertHistoryEntity alertHistory WHERE alertHistory.clusterId = :clusterId AND alertHistory.alertState IN :alertStates"), @NamedQuery(name="AlertHistoryEntity.findAllInClusterBetweenDates", query="SELECT alertHistory FROM AlertHistoryEntity alertHistory WHERE alertHistory.clusterId = :clusterId AND alertHistory.alertTimestamp BETWEEN :startDate AND :endDate"), @NamedQuery(name="AlertHistoryEntity.findAllInClusterBeforeDate", query="SELECT alertHistory FROM AlertHistoryEntity alertHistory WHERE alertHistory.clusterId = :clusterId AND alertHistory.alertTimestamp <= :beforeDate"), @NamedQuery(name="AlertHistoryEntity.findAllIdsInClusterBeforeDate", query="SELECT alertHistory.alertId FROM AlertHistoryEntity alertHistory WHERE alertHistory.clusterId = :clusterId AND alertHistory.alertTimestamp <= :beforeDate"), @NamedQuery(name="AlertHistoryEntity.findAllInClusterAfterDate", query="SELECT alertHistory FROM AlertHistoryEntity alertHistory WHERE alertHistory.clusterId = :clusterId AND alertHistory.alertTimestamp >= :afterDate"), @NamedQuery(name="AlertHistoryEntity.removeByDefinitionId", query="DELETE FROM AlertHistoryEntity alertHistory WHERE alertHistory.alertDefinitionId = :definitionId"), @NamedQuery(name="AlertHistoryEntity.removeInClusterBeforeDate", query="DELETE FROM AlertHistoryEntity alertHistory WHERE alertHistory.clusterId = :clusterId AND alertHistory.alertTimestamp <= :beforeDate"), @NamedQuery(name="AlertHistoryEntity.findHistoryIdsByDefinitionId", query="SELECT alertHistory.alertId FROM AlertHistoryEntity alertHistory WHERE alertHistory.alertDefinitionId = :definitionId ORDER BY alertHistory.alertId")})
public class AlertHistoryEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="alert_history_id_generator")
    @Column(name="alert_id", nullable=false, updatable=false)
    private Long alertId;
    @Column(name="alert_instance", length=255)
    private String alertInstance;
    @Column(name="alert_label", length=1024)
    private String alertLabel;
    @Enumerated(value=EnumType.STRING)
    @Column(name="alert_state", nullable=false, length=255)
    private AlertState alertState;
    @Lob
    @Column(name="alert_text")
    private String alertText;
    @Column(name="alert_timestamp", nullable=false)
    private Long alertTimestamp;
    @Column(name="cluster_id", nullable=false)
    private Long clusterId;
    @Column(name="component_name", length=255)
    private String componentName;
    @Column(name="host_name", length=255)
    private String hostName;
    @Column(name="service_name", nullable=false, length=255)
    private String serviceName;
    @ManyToOne
    @JoinColumn(name="alert_definition_id", nullable=false)
    private AlertDefinitionEntity alertDefinition;
    @Column(name="alert_definition_id", nullable=false, insertable=false, updatable=false, length=10)
    private Long alertDefinitionId;

    public Long getAlertId() {
        return this.alertId;
    }

    public void setAlertId(Long alertId) {
        this.alertId = alertId;
    }

    public String getAlertInstance() {
        return this.alertInstance;
    }

    public void setAlertInstance(String alertInstance) {
        this.alertInstance = alertInstance;
    }

    public String getAlertLabel() {
        return this.alertLabel;
    }

    public void setAlertLabel(String alertLabel) {
        this.alertLabel = alertLabel;
    }

    public AlertState getAlertState() {
        return this.alertState;
    }

    public void setAlertState(AlertState alertState) {
        this.alertState = alertState;
    }

    public String getAlertText() {
        return this.alertText;
    }

    public void setAlertText(String alertText) {
        this.alertText = alertText;
    }

    public Long getAlertTimestamp() {
        return this.alertTimestamp;
    }

    public void setAlertTimestamp(Long alertTimestamp) {
        this.alertTimestamp = alertTimestamp;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public AlertDefinitionEntity getAlertDefinition() {
        return this.alertDefinition;
    }

    public void setAlertDefinition(AlertDefinitionEntity alertDefinition) {
        this.alertDefinition = alertDefinition;
        this.alertDefinitionId = alertDefinition.getDefinitionId();
    }

    public Long getAlertDefinitionId() {
        return this.alertDefinitionId;
    }

    public void setAlertDefinitionId(Long alertDefinitionId) {
        this.alertDefinitionId = alertDefinitionId;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AlertHistoryEntity that = (AlertHistoryEntity)object;
        if (null != this.alertId) {
            return Objects.equals(this.alertId, that.alertId);
        }
        return Objects.equals(this.alertId, that.alertId) && Objects.equals(this.clusterId, that.clusterId) && Objects.equals(this.alertInstance, that.alertInstance) && Objects.equals(this.alertLabel, that.alertLabel) && Objects.equals((Object)this.alertState, (Object)that.alertState) && Objects.equals(this.alertText, that.alertText) && Objects.equals(this.alertTimestamp, that.alertTimestamp) && Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.componentName, that.componentName) && Objects.equals(this.hostName, that.hostName) && Objects.equals(this.alertDefinition, that.alertDefinition);
    }

    public int hashCode() {
        if (null != this.alertId) {
            return this.alertId.hashCode();
        }
        return Objects.hash(new Object[]{this.alertId, this.clusterId, this.alertInstance, this.alertLabel, this.alertState, this.alertText, this.alertTimestamp, this.serviceName, this.componentName, this.hostName, this.alertDefinition});
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName());
        buffer.append("{");
        buffer.append("id=").append(this.alertId);
        buffer.append(", serviceName=").append(this.serviceName);
        buffer.append(", componentName=").append(this.componentName);
        buffer.append(", state=").append((Object)this.alertState);
        buffer.append(", label=").append(this.alertLabel);
        buffer.append("}");
        return buffer.toString();
    }

    public int getAlertDefinitionHash() {
        return this.getAlertDefinition().hashCode();
    }
}

