/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.orm.entities.AlertTargetEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@Entity
@Table(name="alert_group", uniqueConstraints={@UniqueConstraint(columnNames={"cluster_id", "group_name"})})
@TableGenerator(name="alert_group_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="alert_group_id_seq", initialValue=0)
@NamedQueries(value={@NamedQuery(name="AlertGroupEntity.findAll", query="SELECT alertGroup FROM AlertGroupEntity alertGroup"), @NamedQuery(name="AlertGroupEntity.findAllInCluster", query="SELECT alertGroup FROM AlertGroupEntity alertGroup WHERE alertGroup.clusterId = :clusterId"), @NamedQuery(name="AlertGroupEntity.findByNameInCluster", query="SELECT alertGroup FROM AlertGroupEntity alertGroup WHERE alertGroup.groupName = :groupName AND alertGroup.clusterId = :clusterId"), @NamedQuery(name="AlertGroupEntity.findByAssociatedDefinition", query="SELECT alertGroup FROM AlertGroupEntity alertGroup WHERE :alertDefinition MEMBER OF alertGroup.alertDefinitions"), @NamedQuery(name="AlertGroupEntity.findServiceDefaultGroup", query="SELECT alertGroup FROM AlertGroupEntity alertGroup WHERE alertGroup.clusterId = :clusterId AND alertGroup.serviceName = :serviceName AND alertGroup.isDefault = 1"), @NamedQuery(name="AlertGroupEntity.findByIds", query="SELECT alertGroup FROM AlertGroupEntity alertGroup WHERE alertGroup.groupId IN :groupIds")})
public class AlertGroupEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="alert_group_id_generator")
    @Column(name="group_id", nullable=false, updatable=false)
    private Long groupId;
    @Column(name="cluster_id", nullable=false)
    private Long clusterId;
    @Column(name="group_name", nullable=false, length=255)
    private String groupName;
    @Column(name="is_default", nullable=false)
    private Integer isDefault = 0;
    @Column(name="service_name", nullable=true, length=255)
    private String serviceName;
    @ManyToMany(cascade={CascadeType.MERGE})
    @JoinTable(name="alert_grouping", joinColumns={@JoinColumn(name="group_id", nullable=false)}, inverseJoinColumns={@JoinColumn(name="definition_id", nullable=false)})
    private Set<AlertDefinitionEntity> alertDefinitions;
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.MERGE, CascadeType.REFRESH})
    @JoinTable(name="alert_group_target", joinColumns={@JoinColumn(name="group_id", nullable=false)}, inverseJoinColumns={@JoinColumn(name="target_id", nullable=false)})
    private Set<AlertTargetEntity> alertTargets;

    public Long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public boolean isDefault() {
        return this.isDefault != 0;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = !isDefault ? 0 : 1;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Set<AlertDefinitionEntity> getAlertDefinitions() {
        if (null == this.alertDefinitions) {
            this.alertDefinitions = new HashSet<AlertDefinitionEntity>();
        }
        return Collections.unmodifiableSet(this.alertDefinitions);
    }

    public void setAlertDefinitions(Set<AlertDefinitionEntity> alertDefinitions) {
        if (null != this.alertDefinitions) {
            for (AlertDefinitionEntity definition : this.alertDefinitions) {
                definition.removeAlertGroup(this);
            }
        }
        this.alertDefinitions = alertDefinitions;
        if (null != alertDefinitions) {
            for (AlertDefinitionEntity definition : alertDefinitions) {
                definition.addAlertGroup(this);
            }
        }
    }

    public void addAlertDefinition(AlertDefinitionEntity definition) {
        if (null == this.alertDefinitions) {
            this.alertDefinitions = new HashSet<AlertDefinitionEntity>();
        }
        this.alertDefinitions.add(definition);
        definition.addAlertGroup(this);
    }

    public void removeAlertDefinition(AlertDefinitionEntity definition) {
        if (null != this.alertDefinitions) {
            this.alertDefinitions.remove(definition);
        }
        definition.removeAlertGroup(this);
    }

    public Set<AlertTargetEntity> getAlertTargets() {
        if (null == this.alertTargets) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.alertTargets);
    }

    public void addAlertTarget(AlertTargetEntity alertTarget) {
        if (null == this.alertTargets) {
            this.alertTargets = new HashSet<AlertTargetEntity>();
        }
        this.alertTargets.add(alertTarget);
        alertTarget.addAlertGroup(this);
    }

    public void removeAlertTarget(AlertTargetEntity alertTarget) {
        if (null != this.alertTargets) {
            this.alertTargets.remove(alertTarget);
        }
        alertTarget.removeAlertGroup(this);
    }

    public void setAlertTargets(Set<AlertTargetEntity> alertTargets) {
        if (null != this.alertTargets) {
            HashSet<AlertTargetEntity> copyOfAssociatedTargets = new HashSet<AlertTargetEntity>(this.alertTargets);
            for (AlertTargetEntity target : copyOfAssociatedTargets) {
                target.removeAlertGroup(this);
            }
        }
        if (null != alertTargets) {
            for (AlertTargetEntity target : alertTargets) {
                target.addAlertGroup(this);
            }
        }
        this.alertTargets = alertTargets;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AlertGroupEntity that = (AlertGroupEntity)object;
        if (null != this.groupId) {
            return Objects.equals(this.groupId, that.groupId);
        }
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.clusterId, that.clusterId) && Objects.equals(this.groupName, that.groupName) && Objects.equals(this.serviceName, that.serviceName);
    }

    public int hashCode() {
        if (null != this.groupId) {
            return this.groupId.hashCode();
        }
        return Objects.hash(this.groupId, this.clusterId, this.groupName, this.serviceName);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName());
        buffer.append("{");
        buffer.append("id=").append(this.groupId);
        buffer.append(", name=").append(this.groupName);
        buffer.append(", default=").append(this.isDefault);
        buffer.append("}");
        return buffer.toString();
    }
}

