/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.AlertGroupEntity;
import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.state.alert.Scope;
import id.onyx.obdp.server.state.alert.SourceType;
import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.PreRemove;
import jakarta.persistence.QueryHint;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

@Entity
@Table(name="alert_definition", uniqueConstraints={@UniqueConstraint(columnNames={"cluster_id", "definition_name"})})
@TableGenerator(name="alert_definition_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="alert_definition_id_seq", initialValue=0)
@NamedQueries(value={@NamedQuery(name="AlertDefinitionEntity.findAll", query="SELECT ad FROM AlertDefinitionEntity ad"), @NamedQuery(name="AlertDefinitionEntity.findAllInCluster", query="SELECT ad FROM AlertDefinitionEntity ad WHERE ad.clusterId = :clusterId"), @NamedQuery(name="AlertDefinitionEntity.findAllEnabledInCluster", query="SELECT ad FROM AlertDefinitionEntity ad WHERE ad.clusterId = :clusterId AND ad.enabled = 1"), @NamedQuery(name="AlertDefinitionEntity.findByName", query="SELECT ad FROM AlertDefinitionEntity ad WHERE ad.definitionName = :definitionName AND ad.clusterId = :clusterId", hints={@QueryHint(name="eclipselink.query-results-cache", value="true"), @QueryHint(name="eclipselink.query-results-cache.ignore-null", value="true"), @QueryHint(name="eclipselink.query-results-cache.size", value="5000")}), @NamedQuery(name="AlertDefinitionEntity.findByService", query="SELECT ad FROM AlertDefinitionEntity ad WHERE ad.serviceName = :serviceName AND ad.clusterId = :clusterId"), @NamedQuery(name="AlertDefinitionEntity.findByServiceAndComponent", query="SELECT ad FROM AlertDefinitionEntity ad WHERE ad.serviceName = :serviceName AND ad.componentName = :componentName AND ad.clusterId = :clusterId"), @NamedQuery(name="AlertDefinitionEntity.findByServiceMaster", query="SELECT ad FROM AlertDefinitionEntity ad WHERE ad.serviceName IN :services AND ad.scope = :scope AND ad.clusterId = :clusterId AND ad.componentName IS NULL AND ad.sourceType <> id.onyx.obdp.server.state.alert.SourceType.AGGREGATE"), @NamedQuery(name="AlertDefinitionEntity.findByIds", query="SELECT ad FROM AlertDefinitionEntity ad WHERE ad.definitionId IN :definitionIds"), @NamedQuery(name="AlertDefinitionEntity.findBySourceType", query="SELECT ad FROM AlertDefinitionEntity ad WHERE ad.clusterId = :clusterId AND ad.sourceType = :sourceType")})
public class AlertDefinitionEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="alert_definition_id_generator")
    @Column(name="definition_id", nullable=false, updatable=false)
    private Long definitionId;
    @Lob
    @Basic
    @Column(name="alert_source", nullable=false, length=32672)
    private String source;
    @Column(name="cluster_id", nullable=false)
    private Long clusterId;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="cluster_id", referencedColumnName="cluster_id", insertable=false, updatable=false)
    private ClusterEntity clusterEntity;
    @Column(name="component_name", length=255)
    private String componentName;
    @Column(name="definition_name", nullable=false, length=255)
    private String definitionName;
    @Column(name="label", nullable=true, length=255)
    private String label;
    @Column(name="help_url", nullable=true, length=512)
    private String helpURL;
    @Lob
    @Basic
    @Column(name="description", nullable=true, length=32672)
    private String description;
    @Column(name="scope", length=255)
    @Enumerated(value=EnumType.STRING)
    private Scope scope;
    @Column(nullable=false)
    private Integer enabled = 1;
    @Column(nullable=false, length=64)
    private String hash;
    @Column(name="schedule_interval", nullable=false)
    private Integer scheduleInterval;
    @Column(name="service_name", nullable=false, length=255)
    private String serviceName;
    @Column(name="source_type", nullable=false, length=255)
    @Enumerated(value=EnumType.STRING)
    private SourceType sourceType;
    @Column(name="ignore_host", nullable=false)
    private Integer ignoreHost = 0;
    @Column(name="repeat_tolerance", nullable=false)
    private Integer repeatTolerance = 1;
    @Column(name="repeat_tolerance_enabled", nullable=false)
    private Short repeatToleranceEnabled = 0;
    @ManyToMany(mappedBy="alertDefinitions", cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH})
    private Set<AlertGroupEntity> alertGroups;

    public Long getDefinitionId() {
        return this.definitionId;
    }

    public void setDefinitionId(Long definitionId) {
        this.definitionId = definitionId;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String alertSource) {
        this.source = alertSource;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public ClusterEntity getCluster() {
        return this.clusterEntity;
    }

    public void setCluster(ClusterEntity clusterEntity) {
        this.clusterEntity = clusterEntity;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public String getDefinitionName() {
        return this.definitionName;
    }

    public void setDefinitionName(String definitionName) {
        this.definitionName = definitionName;
    }

    public boolean getEnabled() {
        return !Objects.equals(this.enabled, 0);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled ? Integer.valueOf(1) : Integer.valueOf(0);
    }

    public boolean isHostIgnored() {
        return !Objects.equals(this.ignoreHost, 0);
    }

    public void setHostIgnored(boolean ignoreHost) {
        this.ignoreHost = ignoreHost ? Integer.valueOf(1) : Integer.valueOf(0);
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public Integer getScheduleInterval() {
        return this.scheduleInterval;
    }

    public void setScheduleInterval(Integer scheduleInterval) {
        this.scheduleInterval = scheduleInterval;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(SourceType sourceType) {
        this.sourceType = sourceType;
    }

    public Set<AlertGroupEntity> getAlertGroups() {
        return Collections.unmodifiableSet(this.alertGroups);
    }

    public void setAlertGroups(Set<AlertGroupEntity> alertGroups) {
        this.alertGroups = alertGroups;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String getHelpURL() {
        return this.helpURL;
    }

    public void setHelpURL(String helpURL) {
        this.helpURL = helpURL;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getRepeatTolerance() {
        return this.repeatTolerance;
    }

    public void setRepeatTolerance(int repeatTolerance) {
        this.repeatTolerance = repeatTolerance;
    }

    public boolean isRepeatToleranceEnabled() {
        return !Objects.equals(this.repeatToleranceEnabled, (short)0);
    }

    public void setRepeatToleranceEnabled(boolean enabled) {
        this.repeatToleranceEnabled = enabled ? Short.valueOf((short)1) : (short)0;
    }

    protected void addAlertGroup(AlertGroupEntity alertGroup) {
        if (null == this.alertGroups) {
            this.alertGroups = new HashSet<AlertGroupEntity>();
        }
        this.alertGroups.add(alertGroup);
    }

    protected void removeAlertGroup(AlertGroupEntity alertGroup) {
        if (null != this.alertGroups && this.alertGroups.contains(alertGroup)) {
            this.alertGroups.remove(alertGroup);
        }
    }

    @PreRemove
    public void preRemove() {
        if (null == this.alertGroups || this.alertGroups.size() == 0) {
            return;
        }
        Iterator<AlertGroupEntity> iterator = this.alertGroups.iterator();
        while (iterator.hasNext()) {
            AlertGroupEntity group = iterator.next();
            iterator.remove();
            group.removeAlertDefinition(this);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AlertDefinitionEntity that = (AlertDefinitionEntity)object;
        if (null != this.definitionId) {
            return Objects.equals(this.definitionId, that.definitionId);
        }
        return Objects.equals(this.definitionId, that.definitionId) && Objects.equals(this.clusterId, that.clusterId) && Objects.equals(this.definitionName, that.definitionName);
    }

    public int hashCode() {
        if (null != this.definitionId) {
            return this.definitionId.hashCode();
        }
        return Objects.hash(this.definitionId, this.clusterId, this.definitionName);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName());
        buffer.append("{");
        buffer.append("id=").append(this.definitionId);
        buffer.append(", name=").append(this.definitionName);
        buffer.append(", serviceName=").append(this.serviceName);
        buffer.append(", componentName=").append(this.componentName);
        buffer.append(", enabled=").append(this.enabled);
        buffer.append(", hash=").append(this.hash);
        buffer.append("}");
        return buffer.toString();
    }
}

