/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.orm.entities.AlertHistoryEntity;
import id.onyx.obdp.server.state.AlertFirmness;
import id.onyx.obdp.server.state.MaintenanceState;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.Objects;
import org.apache.commons.lang.builder.EqualsBuilder;

@Entity
@Table(name="alert_current")
@TableGenerator(name="alert_current_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="alert_current_id_seq", initialValue=0)
@NamedQueries(value={@NamedQuery(name="AlertCurrentEntity.findAll", query="SELECT alert FROM AlertCurrentEntity alert"), @NamedQuery(name="AlertCurrentEntity.findByCluster", query="SELECT alert FROM AlertCurrentEntity alert WHERE alert.alertHistory.clusterId = :clusterId"), @NamedQuery(name="AlertCurrentEntity.findByDefinitionId", query="SELECT alert FROM AlertCurrentEntity alert WHERE alert.alertDefinition.definitionId = :definitionId"), @NamedQuery(name="AlertCurrentEntity.findByService", query="SELECT alert FROM AlertCurrentEntity alert WHERE alert.alertHistory.clusterId = :clusterId AND alert.alertHistory.serviceName = :serviceName AND alert.alertHistory.alertDefinition.scope IN :inlist"), @NamedQuery(name="AlertCurrentEntity.findByHostAndName", query="SELECT alert FROM AlertCurrentEntity alert WHERE alert.alertHistory.clusterId = :clusterId AND alert.alertHistory.alertDefinition.definitionName = :definitionName AND alert.alertHistory.hostName = :hostName"), @NamedQuery(name="AlertCurrentEntity.findByNameAndNoHost", query="SELECT alert FROM AlertCurrentEntity alert WHERE alert.alertHistory.clusterId = :clusterId AND alert.alertHistory.alertDefinition.definitionName = :definitionName AND alert.alertHistory.hostName IS NULL"), @NamedQuery(name="AlertCurrentEntity.findByHostComponent", query="SELECT alert FROM AlertCurrentEntity alert WHERE alert.alertHistory.serviceName = :serviceName AND alert.alertHistory.componentName = :componentName AND alert.alertHistory.hostName = :hostName"), @NamedQuery(name="AlertCurrentEntity.findByHost", query="SELECT alert FROM AlertCurrentEntity alert WHERE alert.alertHistory.hostName = :hostName"), @NamedQuery(name="AlertCurrentEntity.findByServiceName", query="SELECT alert FROM AlertCurrentEntity alert WHERE alert.alertHistory.serviceName = :serviceName"), @NamedQuery(name="AlertCurrentEntity.findDisabled", query="SELECT alert FROM AlertCurrentEntity alert WHERE alert.alertDefinition.enabled = 0"), @NamedQuery(name="AlertCurrentEntity.removeByHistoryId", query="DELETE FROM AlertCurrentEntity alert WHERE alert.historyId = :historyId"), @NamedQuery(name="AlertCurrentEntity.removeByHistoryIds", query="DELETE FROM AlertCurrentEntity alert WHERE alert.historyId IN :historyIds"), @NamedQuery(name="AlertCurrentEntity.removeByDefinitionId", query="DELETE FROM AlertCurrentEntity alert WHERE alert.definitionId = :definitionId")})
public class AlertCurrentEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="alert_current_id_generator")
    @Column(name="alert_id", nullable=false, updatable=false)
    private Long alertId;
    @Column(name="history_id", nullable=false, insertable=false, updatable=false, length=10)
    private Long historyId;
    @Column(name="definition_id", nullable=false, insertable=false, updatable=false, length=10)
    private Long definitionId;
    @Column(name="latest_timestamp", nullable=false)
    private Long latestTimestamp;
    @Column(name="maintenance_state", length=255)
    @Enumerated(value=EnumType.STRING)
    private MaintenanceState maintenanceState = MaintenanceState.OFF;
    @Column(name="original_timestamp", nullable=false)
    private Long originalTimestamp;
    @Lob
    @Column(name="latest_text")
    private String latestText = null;
    @Column(name="occurrences", nullable=false)
    private Long occurrences = 1L;
    @Column(name="firmness", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private AlertFirmness firmness = AlertFirmness.HARD;
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(name="history_id", unique=true, nullable=false)
    private AlertHistoryEntity alertHistory;
    @OneToOne
    @JoinColumn(name="definition_id", unique=false, nullable=false)
    private AlertDefinitionEntity alertDefinition;

    public Long getAlertId() {
        return this.alertId;
    }

    public void setAlertId(Long alertId) {
        this.alertId = alertId;
    }

    public Long getHistoryId() {
        return this.historyId;
    }

    public void setHistoryId(Long historyId) {
        this.historyId = historyId;
    }

    public Long getDefinitionId() {
        return this.definitionId;
    }

    public void setDefinitionId(Long definitionId) {
        this.definitionId = definitionId;
    }

    public Long getLatestTimestamp() {
        return this.latestTimestamp;
    }

    public void setLatestTimestamp(Long latestTimestamp) {
        this.latestTimestamp = latestTimestamp;
    }

    public MaintenanceState getMaintenanceState() {
        return this.maintenanceState;
    }

    public void setMaintenanceState(MaintenanceState maintenanceState) {
        this.maintenanceState = maintenanceState;
    }

    public Long getOriginalTimestamp() {
        return this.originalTimestamp;
    }

    public void setOriginalTimestamp(Long originalTimestamp) {
        this.originalTimestamp = originalTimestamp;
    }

    public String getLatestText() {
        return this.latestText;
    }

    public void setLatestText(String text) {
        this.latestText = text;
    }

    public Long getOccurrences() {
        return this.occurrences;
    }

    public void setOccurrences(long occurrences) {
        this.occurrences = occurrences;
    }

    public AlertFirmness getFirmness() {
        return this.firmness;
    }

    public void setFirmness(AlertFirmness firmness) {
        this.firmness = firmness;
    }

    public AlertHistoryEntity getAlertHistory() {
        return this.alertHistory;
    }

    public void setAlertHistory(AlertHistoryEntity alertHistory) {
        this.alertHistory = alertHistory;
        this.historyId = alertHistory.getAlertId();
        this.alertDefinition = alertHistory.getAlertDefinition();
        this.definitionId = alertHistory.getAlertDefinitionId();
        this.latestText = alertHistory.getAlertText();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AlertCurrentEntity that = (AlertCurrentEntity)object;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)this.alertId, (Object)that.alertId);
        equalsBuilder.append((Object)this.alertHistory, (Object)that.alertHistory);
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        return Objects.hash(this.alertId, this.alertHistory);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("AlertCurrentEntity{");
        buffer.append("alertId=").append(this.alertId);
        if (null != this.alertDefinition) {
            buffer.append(", name=").append(this.alertDefinition.getDefinitionName());
        }
        if (null != this.alertHistory) {
            buffer.append(", state=").append((Object)this.alertHistory.getAlertState());
        }
        buffer.append(", latestTimestamp=").append(this.latestTimestamp);
        buffer.append("}");
        return buffer.toString();
    }
}

