/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.WidgetLayoutEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.List;

@Singleton
public class WidgetLayoutDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    private DaoUtils daoUtils;

    @RequiresSession
    public WidgetLayoutEntity findById(Long id) {
        return (WidgetLayoutEntity)((EntityManager)this.entityManagerProvider.get()).find(WidgetLayoutEntity.class, (Object)id);
    }

    @RequiresSession
    public List<WidgetLayoutEntity> findByCluster(long clusterId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("WidgetLayoutEntity.findByCluster", WidgetLayoutEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<WidgetLayoutEntity> findBySectionName(String sectionName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("WidgetLayoutEntity.findBySectionName", WidgetLayoutEntity.class);
        query.setParameter("sectionName", (Object)sectionName);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<WidgetLayoutEntity> findByName(Long clusterId, String layoutName, String userName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("WidgetLayoutEntity.findByName", WidgetLayoutEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("layoutName", (Object)layoutName);
        query.setParameter("userName", (Object)userName);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<WidgetLayoutEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("WidgetLayoutEntity.findAll", WidgetLayoutEntity.class);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @Transactional
    public void create(WidgetLayoutEntity widgetLayoutEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)widgetLayoutEntity);
    }

    @Transactional
    public void createWithFlush(WidgetLayoutEntity widgetLayoutEntity) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        entityManager.persist((Object)widgetLayoutEntity);
        entityManager.flush();
        entityManager.refresh((Object)widgetLayoutEntity);
    }

    @Transactional
    public WidgetLayoutEntity merge(WidgetLayoutEntity widgetLayoutEntity) {
        return (WidgetLayoutEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)widgetLayoutEntity);
    }

    @Transactional
    public WidgetLayoutEntity mergeWithFlush(WidgetLayoutEntity widgetLayoutEntity) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        widgetLayoutEntity = (WidgetLayoutEntity)entityManager.merge((Object)widgetLayoutEntity);
        entityManager.flush();
        entityManager.refresh((Object)widgetLayoutEntity);
        return widgetLayoutEntity;
    }

    @Transactional
    public void remove(WidgetLayoutEntity widgetLayoutEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(widgetLayoutEntity));
    }

    @Transactional
    public void removeByPK(Long id) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.findById(id));
    }

    @Transactional
    public void refresh(WidgetLayoutEntity widgetLayoutEntity) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)widgetLayoutEntity);
    }
}

