/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.WidgetEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.List;

@Singleton
public class WidgetDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    private DaoUtils daoUtils;

    @RequiresSession
    public WidgetEntity findById(Long id) {
        return (WidgetEntity)((EntityManager)this.entityManagerProvider.get()).find(WidgetEntity.class, (Object)id);
    }

    @RequiresSession
    public List<WidgetEntity> findByCluster(long clusterId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("WidgetEntity.findByCluster", WidgetEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<WidgetEntity> findBySectionName(String sectionName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("WidgetEntity.findBySectionName", WidgetEntity.class);
        query.setParameter("sectionName", (Object)sectionName);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<WidgetEntity> findByName(Long clusterId, String widgetName, String author, String defaultSectionName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("WidgetEntity.findByName", WidgetEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("widgetName", (Object)widgetName);
        query.setParameter("author", (Object)author);
        query.setParameter("defaultSectionName", (Object)defaultSectionName);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<WidgetEntity> findByScopeOrAuthor(String author, String scope) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("WidgetEntity.findByScopeOrAuthor", WidgetEntity.class);
        query.setParameter("author", (Object)author);
        query.setParameter("scope", (Object)scope);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<WidgetEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("WidgetEntity.findAll", WidgetEntity.class);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @Transactional
    public void create(WidgetEntity widgetEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)widgetEntity);
    }

    @Transactional
    public WidgetEntity merge(WidgetEntity widgetEntity) {
        return (WidgetEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)widgetEntity);
    }

    @Transactional
    public void remove(WidgetEntity widgetEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(widgetEntity));
    }

    @Transactional
    public void removeByPK(Long id) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.findById(id));
    }

    @Transactional
    public void refresh(WidgetEntity widgetEntity) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)widgetEntity);
    }
}

