/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.entities.ViewURLEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.List;

@Singleton
public class ViewURLDAO {
    @Inject
    private Provider<EntityManager> entityManagerProvider;

    @RequiresSession
    public List<ViewURLEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("allViewUrls", ViewURLEntity.class);
        return query.getResultList();
    }

    @RequiresSession
    public Optional<ViewURLEntity> findByName(String urlName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("viewUrlByName", ViewURLEntity.class);
        query.setParameter("urlName", (Object)urlName);
        try {
            return Optional.of((Object)((ViewURLEntity)query.getSingleResult()));
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }

    @RequiresSession
    public Optional<ViewURLEntity> findBySuffix(String urlSuffix) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("viewUrlBySuffix", ViewURLEntity.class);
        query.setParameter("urlSuffix", (Object)urlSuffix);
        try {
            return Optional.of((Object)((ViewURLEntity)query.getSingleResult()));
        }
        catch (NoResultException e) {
            return Optional.absent();
        }
    }

    @Transactional
    public void save(ViewURLEntity urlEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)urlEntity);
        ((EntityManager)this.entityManagerProvider.get()).flush();
    }

    @Transactional
    public void update(ViewURLEntity entity) {
        ((EntityManager)this.entityManagerProvider.get()).merge((Object)entity);
        ((EntityManager)this.entityManagerProvider.get()).flush();
    }

    @Transactional
    public void delete(ViewURLEntity urlEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)urlEntity);
        ((EntityManager)this.entityManagerProvider.get()).flush();
    }
}

