/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.ResourceEntity;
import id.onyx.obdp.server.orm.entities.ViewInstanceDataEntity;
import id.onyx.obdp.server.orm.entities.ViewInstanceEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.List;

@Singleton
public class ViewInstanceDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    @RequiresSession
    public ViewInstanceEntity findByName(String viewName, String instanceName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("SELECT instance FROM ViewInstanceEntity instance WHERE instance.viewName = ?1 AND instance.name = ?2", ViewInstanceEntity.class);
        return (ViewInstanceEntity)this.daoUtils.selectSingle(query, viewName, instanceName);
    }

    @RequiresSession
    public ViewInstanceEntity findByResourceId(long resourceId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("viewInstanceByResourceId", ViewInstanceEntity.class);
        query.setParameter("resourceId", (Object)resourceId);
        try {
            return (ViewInstanceEntity)query.getSingleResult();
        }
        catch (NoResultException ignored) {
            return null;
        }
    }

    @RequiresSession
    public List<ViewInstanceEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("allViewInstances", ViewInstanceEntity.class);
        return query.getResultList();
    }

    @RequiresSession
    public ResourceEntity findResourceForViewInstance(String viewName, String instanceName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("getResourceIdByViewInstance", ResourceEntity.class);
        query.setParameter("viewName", (Object)viewName);
        query.setParameter("instanceName", (Object)instanceName);
        return (ResourceEntity)this.daoUtils.selectOne(query, new Object[0]);
    }

    @Transactional
    public void refresh(ViewInstanceEntity viewInstanceEntity) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)viewInstanceEntity);
    }

    @Transactional
    public void create(ViewInstanceEntity viewInstanceEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)viewInstanceEntity);
    }

    @Transactional
    public ViewInstanceEntity merge(ViewInstanceEntity viewInstanceEntity) {
        return (ViewInstanceEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)viewInstanceEntity);
    }

    @Transactional
    public void remove(ViewInstanceEntity viewInstanceEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(viewInstanceEntity));
    }

    @Transactional
    public ViewInstanceDataEntity mergeData(ViewInstanceDataEntity viewInstanceDataEntity) {
        return (ViewInstanceDataEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)viewInstanceDataEntity);
    }

    @Transactional
    public void removeData(ViewInstanceDataEntity viewInstanceDataEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.mergeData(viewInstanceDataEntity));
    }
}

